/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.settings.widgets;

import com.wynntils.core.persisted.config.Config;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class TextInputBoxSettingsWidget<T>
extends TextInputBoxWidget {
    private final Config<T> config;
    private final int maskTopY;
    private final int maskBottomY;

    protected TextInputBoxSettingsWidget(int x, int y, Config<T> config, TextboxScreen textboxScreen, int maskTopY, int maskBottomY) {
        super(x, y, 90, 20, null, textboxScreen);
        this.config = config;
        this.maskTopY = maskTopY;
        this.maskBottomY = maskBottomY;
        this.setTextBoxInput(config.get().toString());
        this.tooltip = ComponentUtils.wrapTooltips(List.of(class_2561.method_43470((String)config.getDescription())), 150);
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.field_22762 && (mouseY <= this.maskTopY || mouseY >= this.maskBottomY)) {
            this.field_22762 = false;
        }
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void onUpdate(String text) {
        T parsedValue = this.config.tryParseStringValue(text);
        if (parsedValue != null) {
            if (!parsedValue.equals(this.config.get())) {
                this.config.setValue(parsedValue);
            }
            this.setRenderColor(CommonColors.GREEN);
        } else {
            this.setRenderColor(CommonColors.RED);
        }
    }
}

