/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.chat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.chat.type.RecipientType;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ChatTab {
    private final String name;
    private final boolean consuming;
    private final String autoCommand;
    private final Set<RecipientType> filteredTypes;
    private final String customRegexString;
    private transient Pattern customRegex;

    public ChatTab(String name, boolean consuming, String autoCommand, Set<RecipientType> filteredTypes, String customRegexString) {
        this.name = name;
        this.consuming = consuming;
        this.autoCommand = autoCommand;
        this.filteredTypes = filteredTypes;
        this.customRegexString = customRegexString;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConsuming() {
        return this.consuming;
    }

    public String getAutoCommand() {
        return this.autoCommand;
    }

    public Optional<Pattern> getCustomRegex() {
        if (this.customRegex == null) {
            this.customRegex = this.compileRegex(this.customRegexString);
        }
        return Optional.ofNullable(this.customRegex);
    }

    public String getCustomRegexString() {
        return this.customRegexString;
    }

    public Set<RecipientType> getFilteredTypes() {
        return this.filteredTypes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ChatTab chatTab = (ChatTab)other;
        return this.consuming == chatTab.consuming && Objects.equals(this.name, chatTab.name) && Objects.equals(this.filteredTypes, chatTab.filteredTypes) && Objects.equals(this.customRegexString, chatTab.customRegexString);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.consuming, this.filteredTypes, this.customRegexString);
    }

    private Pattern compileRegex(String customRegexString) {
        if (customRegexString != null && !customRegexString.isBlank()) {
            try {
                return Pattern.compile(customRegexString, 32);
            }
            catch (PatternSyntaxException e) {
                WynntilsMod.warn("Got a saved invalid chat tab regex: " + customRegexString);
                return null;
            }
        }
        return null;
    }
}

