/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.discord;

import com.wynntils.antiope.core.DiscordGameSDKCore;
import com.wynntils.antiope.core.type.CreateParams;
import com.wynntils.antiope.core.type.GameSDKException;
import com.wynntils.antiope.core.type.Result;
import com.wynntils.antiope.manager.activity.type.Activity;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Service;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.utils.mc.McUtils;
import java.time.Instant;
import java.util.List;
import net.minecraft.class_1074;
import net.neoforged.bus.api.SubscribeEvent;

public class DiscordService
extends Service {
    private static final long DISCORD_APPLICATION_ID = 387266678607577088L;
    private static final int TICKS_PER_UPDATE = 5;
    private CreateParams params;
    private DiscordGameSDKCore core;
    private Activity activity;
    private int ticksUntilUpdate = 0;

    public DiscordService() {
        super(List.of());
    }

    public boolean load() {
        try {
            DiscordGameSDKCore.loadLibrary();
        }
        catch (UnsatisfiedLinkError e) {
            McUtils.sendErrorToClient(class_1074.method_4662((String)"service.wynntils.discord.failedToLoadSDK", (Object[])new Object[0]));
            WynntilsMod.error("Failed to load Discord Rich Presence library", e);
            return false;
        }
        if (!this.isReady()) {
            this.createCore();
        }
        return true;
    }

    public boolean isReady() {
        return this.core != null && this.core.isOpen() && this.activity != null;
    }

    public void unload() {
        if (!this.isReady()) {
            return;
        }
        try {
            this.activity.close();
            this.activity = null;
            this.core.close();
            this.core = null;
            this.params.close();
            this.params = null;
        }
        catch (GameSDKException e) {
            if (e.getResult() == Result.TRANSACTION_ABORTED) {
                return;
            }
            WynntilsMod.error("Could not unload Discord Game SDK", e);
        }
    }

    private void createCore() {
        this.params = new CreateParams();
        try {
            this.params.setClientID(387266678607577088L);
            this.params.setFlags(CreateParams.getNoRequireDiscordFlags());
            this.core = new DiscordGameSDKCore(this.params);
            this.activity = new Activity();
            this.activity.timestamps().setStart(Instant.now());
            this.activity.assets().setSmallImage("wynntils");
            this.activity.assets().setSmallText("Wynntils " + WynntilsMod.getVersion() + " (" + McUtils.mc().method_1515() + ")");
        }
        catch (Throwable e) {
            GameSDKException gameSDKException;
            if (e instanceof GameSDKException && (gameSDKException = (GameSDKException)e).getResult() == Result.INTERNAL_ERROR) {
                return;
            }
            WynntilsMod.error("Could not initialize Discord Game SDK", e);
        }
    }

    public void setDetails(String details) {
        if (!this.isReady()) {
            return;
        }
        this.activity.setDetails(details);
        this.core.activityManager().updateActivity(this.activity);
    }

    public void setImage(String imageId) {
        if (!this.isReady()) {
            return;
        }
        this.activity.assets().setLargeImage(imageId);
        this.core.activityManager().updateActivity(this.activity);
    }

    public void setImageText(String text) {
        if (!this.isReady()) {
            return;
        }
        this.activity.assets().setLargeText(text);
        this.core.activityManager().updateActivity(this.activity);
    }

    public void setWynncraftLogo() {
        if (!this.isReady()) {
            return;
        }
        this.activity.assets().setLargeImage("wynn");
        this.activity.assets().setLargeText("play.wynncraft.com");
        this.core.activityManager().updateActivity(this.activity);
    }

    public void setState(String state) {
        if (!this.isReady()) {
            return;
        }
        this.activity.setState(state);
        this.core.activityManager().updateActivity(this.activity);
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (this.ticksUntilUpdate > 0) {
            --this.ticksUntilUpdate;
            return;
        }
        this.ticksUntilUpdate = 5;
        if (!this.isReady()) {
            return;
        }
        this.core.runCallbacks();
    }
}

