/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.hades;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.features.players.HadesFeature;
import com.wynntils.hades.objects.HadesConnection;
import com.wynntils.hades.protocol.interfaces.adapters.IHadesClientAdapter;
import com.wynntils.hades.protocol.packets.client.HCPacketAuthenticate;
import com.wynntils.hades.protocol.packets.server.HSPacketAuthenticationResponse;
import com.wynntils.hades.protocol.packets.server.HSPacketClearMutual;
import com.wynntils.hades.protocol.packets.server.HSPacketDisconnect;
import com.wynntils.hades.protocol.packets.server.HSPacketDiscordLobbyServer;
import com.wynntils.hades.protocol.packets.server.HSPacketPong;
import com.wynntils.hades.protocol.packets.server.HSPacketUpdateMutual;
import com.wynntils.services.hades.HadesUser;
import com.wynntils.services.hades.HadesUserRegistry;
import com.wynntils.services.hades.event.HadesEvent;
import com.wynntils.services.hades.event.HadesUserEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class HadesClientHandler
implements IHadesClientAdapter {
    private final HadesConnection hadesConnection;
    private final HadesUserRegistry userRegistry;

    public HadesClientHandler(HadesConnection hadesConnection, HadesUserRegistry userRegistry) {
        this.hadesConnection = hadesConnection;
        this.userRegistry = userRegistry;
        Thread.currentThread().setContextClassLoader(WynntilsMod.class.getClassLoader());
    }

    @Override
    public void onConnect() {
        if (!Services.WynntilsAccount.isLoggedIn()) {
            this.hadesConnection.disconnect();
            if (Managers.Connection.onServer()) {
                McUtils.sendErrorToClient("Could not connect to the remote player server because you are not logged in on Athena.");
            }
            throw new IllegalStateException("Tried to auth to the remote player server without being logged in on Athena.");
        }
        this.hadesConnection.sendPacketAndFlush(new HCPacketAuthenticate(Services.WynntilsAccount.getToken()));
    }

    @Override
    public void onDisconnect() {
        WynntilsMod.postEvent(new HadesEvent.Disconnected());
        if (Managers.Connection.onServer()) {
            McUtils.sendErrorToClient("Disconnected from the remote player server.");
        }
        WynntilsMod.info("Disconnected from the remote player server.");
        this.userRegistry.getHadesUserMap().clear();
    }

    @Override
    public void handleAuthenticationResponse(HSPacketAuthenticationResponse packet) {
        class_5250 userComponent = class_2561.method_43473();
        switch (packet.getResponse()) {
            case SUCCESS: {
                WynntilsMod.info("Successfully connected to the remote player server: " + packet.getMessage());
                userComponent = class_2561.method_43470((String)"Successfully connected to the remote player server.").method_27692(class_124.field_1060);
                WynntilsMod.postEvent(new HadesEvent.Authenticated());
                break;
            }
            case INVALID_TOKEN: {
                WynntilsMod.error("Got invalid token when trying to connect to the remote player server: " + packet.getMessage());
                userComponent = class_2561.method_43470((String)"Got invalid token when connecting the remote player server.").method_27692(class_124.field_1061);
                break;
            }
            case ERROR: {
                WynntilsMod.error("Got an error trying to connect to the remote player server: " + packet.getMessage());
                userComponent = class_2561.method_43470((String)"Got error when connecting the remote player server.").method_27692(class_124.field_1061);
            }
        }
        if (Managers.Connection.onServer()) {
            McUtils.sendMessageToClient((class_2561)userComponent);
        }
    }

    @Override
    public void handlePing(HSPacketPong packet) {
    }

    @Override
    public void handleUpdateMutual(HSPacketUpdateMutual packet) {
        if (!((Boolean)Managers.Feature.getFeatureInstance(HadesFeature.class).getOtherPlayerInfo.get()).booleanValue()) {
            return;
        }
        Optional<HadesUser> userOptional = this.userRegistry.getUser(packet.getUser());
        if (userOptional.isPresent()) {
            userOptional.get().updateFromPacket(packet);
        } else {
            HadesUser hadesUser = new HadesUser(packet);
            this.userRegistry.putUser(packet.getUser(), hadesUser);
            WynntilsMod.postEventOnMainThread(new HadesUserEvent.Added(hadesUser));
        }
    }

    @Override
    public void handleDiscordLobbyServer(HSPacketDiscordLobbyServer packet) {
    }

    @Override
    public void handleClearMutual(HSPacketClearMutual packet) {
        HadesUser oldUser = this.userRegistry.removeUser(packet.getUser());
        WynntilsMod.postEventOnMainThread(new HadesUserEvent.Removed(oldUser));
    }

    @Override
    public void handleDisconnect(HSPacketDisconnect packet) {
        WynntilsMod.info("Disconnected from the remote player server. Reason: " + packet.getReason());
        if (Managers.Connection.onServer()) {
            McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)"[Wynntils] Disconnected from the remote player server.").method_27692(class_124.field_1054));
        }
        this.userRegistry.getHadesUserMap().clear();
    }
}

