/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter.filters;

import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatFilterFactory;
import com.wynntils.utils.StringUtils;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringStatFilter
extends StatFilter<String> {
    private final String searchLiteral;
    private final boolean strict;

    private StringStatFilter(String searchLiteral, boolean strict) {
        this.searchLiteral = searchLiteral;
        this.strict = strict;
    }

    @Override
    public boolean matches(String value) {
        return this.strict ? value.equalsIgnoreCase(this.searchLiteral) : StringUtils.containsIgnoreCase(value, this.searchLiteral);
    }

    @Override
    public String asString() {
        return this.strict ? "\"" + this.searchLiteral + "\"" : this.searchLiteral;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public String getSearchLiteral() {
        return this.searchLiteral;
    }

    public static class StringStatFilterFactory
    extends StatFilterFactory<StringStatFilter> {
        private static final Pattern STRICT_FILTER_PATTERN = Pattern.compile("\"(.+)\"");

        @Override
        public Optional<StringStatFilter> create(String inputString) {
            Matcher matcher = STRICT_FILTER_PATTERN.matcher(inputString);
            if (matcher.matches()) {
                return Optional.of(new StringStatFilter(matcher.group(1), true));
            }
            return Optional.of(new StringStatFilter(inputString, false));
        }
    }
}

