/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter.statproviders;

import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.properties.ProfessionItemProperty;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class ProfessionStatProvider
extends ItemStatProvider<Boolean> {
    private final ProfessionType professionType;

    public ProfessionStatProvider(ProfessionType professionType) {
        this.professionType = professionType;
    }

    @Override
    public String getName() {
        return this.professionType.getDisplayName().toLowerCase(Locale.ROOT);
    }

    @Override
    public String getDisplayName() {
        return this.professionType.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.getTranslation("description", this.professionType.getDisplayName());
    }

    @Override
    public Optional<Boolean> getValue(WynnItem wynnItem) {
        if (!(wynnItem instanceof ProfessionItemProperty)) {
            return Optional.empty();
        }
        ProfessionItemProperty professionItemProperty = (ProfessionItemProperty)((Object)wynnItem);
        return Optional.of(professionItemProperty.getProfessionTypes().contains(this.professionType));
    }

    @Override
    public List<ItemProviderType> getFilterTypes() {
        return List.of(ItemProviderType.PROFESSION);
    }
}

