/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemrecord.type;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.encoding.type.EncodingSettings;
import com.wynntils.utils.EncodedByteBuffer;
import com.wynntils.utils.type.ErrorOr;
import java.lang.reflect.Type;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3902;
import net.minecraft.class_9282;
import net.minecraft.class_9285;
import net.minecraft.class_9300;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public record SavedItem(String base64, Set<String> categories, class_1799 itemStack) implements Comparable<SavedItem>
{
    private static final EncodingSettings SAVED_ITEM_ENCODING_SETTINGS = new EncodingSettings(true, true);

    public static SavedItem create(WynnItem wynnItem, Set<String> categories, class_1799 itemStack) {
        ErrorOr<EncodedByteBuffer> errorOrEncodedByteBuffer = Models.ItemEncoding.encodeItem(wynnItem, SAVED_ITEM_ENCODING_SETTINGS);
        if (errorOrEncodedByteBuffer.hasError()) {
            throw new IllegalArgumentException("Tried to construct a SavedItem with unencodable WynnItem: " + errorOrEncodedByteBuffer.getError());
        }
        return new SavedItem(errorOrEncodedByteBuffer.getValue().toBase64String(), categories, itemStack);
    }

    public WynnItem wynnItem() {
        ErrorOr<WynnItem> errorOrWynnItem = Models.ItemEncoding.decodeItem(EncodedByteBuffer.fromBase64String(this.base64), null);
        if (errorOrWynnItem.hasError()) {
            throw new IllegalStateException("Tried to decode a SavedItem with unencodable WynnItem: " + errorOrWynnItem.getError());
        }
        return errorOrWynnItem.getValue();
    }

    @Override
    public int compareTo(SavedItem other) {
        return this.base64.compareTo(other.base64);
    }

    private record ItemStackInfo(int itemId, int damage, int color) {
    }

    public static class SavedItemSerializer
    implements JsonSerializer<SavedItem>,
    JsonDeserializer<SavedItem> {
        public SavedItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            class_1799 itemStack;
            JsonObject jsonObject = json.getAsJsonObject();
            String base64 = jsonObject.get("base64").getAsString();
            Set categories = (Set)context.deserialize(jsonObject.get("categories"), Set.class);
            if (jsonObject.has("itemStack")) {
                JsonElement itemStackJson = jsonObject.get("itemStack");
                itemStack = (class_1799)class_1799.field_24671.parse((DynamicOps)JsonOps.INSTANCE, (Object)itemStackJson).result().orElseThrow(() -> new JsonParseException("Failed to decode ItemStack"));
            } else if (jsonObject.has("itemStackInfo")) {
                ItemStackInfo info = (ItemStackInfo)context.deserialize(jsonObject.get("itemStackInfo"), ItemStackInfo.class);
                itemStack = new class_1799((class_1935)class_1792.method_7875((int)info.itemId()), 1);
                class_9323.class_9324 componentsBuilder = class_9323.method_57827().method_57840(class_9334.field_49629, (Object)info.damage()).method_57840(class_9334.field_49630, (Object)new class_9300(false)).method_57840(class_9334.field_49638, (Object)class_3902.field_17274);
                if (info.color() != -1) {
                    componentsBuilder.method_57840(class_9334.field_49644, (Object)new class_9282(info.color(), false));
                }
                itemStack.method_57365(componentsBuilder.method_57838());
                itemStack.method_57379(class_9334.field_49636, (Object)((class_9285)itemStack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326)).method_58423(false));
            } else {
                WynntilsMod.error("SavedItem has no itemStack or itemStackInfo");
                itemStack = class_1799.field_8037;
            }
            return new SavedItem(base64, categories, itemStack);
        }

        public JsonElement serialize(SavedItem src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("base64", src.base64());
            jsonObject.add("categories", context.serialize(src.categories()));
            JsonElement itemStackJson = (JsonElement)class_1799.field_24671.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)src.itemStack()).result().orElseThrow(() -> new JsonParseException("Failed to encode ItemStack"));
            jsonObject.add("itemStack", itemStackJson);
            return jsonObject;
        }
    }
}

