/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.lootrunpaths;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.wynntils.core.WynntilsMod;
import com.wynntils.services.lootrunpaths.UncompiledLootrunPath;
import com.wynntils.services.lootrunpaths.type.LootrunNote;
import com.wynntils.services.lootrunpaths.type.LootrunPath;
import com.wynntils.services.lootrunpaths.type.LootrunSaveResult;
import com.wynntils.utils.mc.McUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7225;

public final class LootrunPathFileParser {
    public static UncompiledLootrunPath readJson(File file, JsonObject json) {
        JsonArray points = json.getAsJsonArray("points");
        LootrunPath pointsList = new LootrunPath(new ArrayList<class_243>());
        for (JsonElement element : points) {
            JsonObject pointJson = element.getAsJsonObject();
            class_243 position = new class_243(pointJson.get("x").getAsDouble(), pointJson.get("y").getAsDouble(), pointJson.get("z").getAsDouble());
            pointsList.points().add(position);
        }
        JsonArray chestsJson = json.getAsJsonArray("chests");
        HashSet<class_2338> chests = new HashSet<class_2338>();
        if (chestsJson != null) {
            for (JsonElement element : chestsJson) {
                JsonObject chestJson = element.getAsJsonObject();
                class_2338 pos = new class_2338(chestJson.get("x").getAsInt(), chestJson.get("y").getAsInt(), chestJson.get("z").getAsInt());
                chests.add(pos);
            }
        }
        JsonArray notesJson = json.getAsJsonArray("notes");
        ArrayList<LootrunNote> notes = new ArrayList<LootrunNote>();
        if (notesJson != null) {
            for (JsonElement element : notesJson) {
                JsonObject noteJson = element.getAsJsonObject();
                JsonObject positionJson = noteJson.getAsJsonObject("position");
                if (positionJson == null) {
                    positionJson = noteJson.getAsJsonObject("location");
                }
                class_243 position = new class_243(positionJson.get("x").getAsDouble(), positionJson.get("y").getAsDouble(), positionJson.get("z").getAsDouble());
                class_5250 component = class_2561.class_2562.method_10872((JsonElement)noteJson.get("note"), (class_7225.class_7874)McUtils.mc().field_1724.method_56673());
                LootrunNote note = new LootrunNote((class_2374)position, (class_2561)component);
                notes.add(note);
            }
        }
        return new UncompiledLootrunPath(pointsList, chests, notes, file);
    }

    public static LootrunSaveResult writeJson(UncompiledLootrunPath activeLootrun, File file) {
        try {
            boolean result = file.createNewFile();
            if (!result) {
                return LootrunSaveResult.ERROR_ALREADY_EXISTS;
            }
            JsonObject json = new JsonObject();
            JsonArray points = new JsonArray();
            for (class_2374 class_23742 : activeLootrun.path().points()) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("x", (Number)class_23742.method_10216());
                jsonObject.addProperty("y", (Number)class_23742.method_10214());
                jsonObject.addProperty("z", (Number)class_23742.method_10215());
                points.add((JsonElement)jsonObject);
            }
            json.add("points", (JsonElement)points);
            JsonArray chests = new JsonArray();
            for (class_2338 class_23382 : activeLootrun.chests()) {
                JsonObject chestJson = new JsonObject();
                chestJson.addProperty("x", (Number)class_23382.method_10263());
                chestJson.addProperty("y", (Number)class_23382.method_10264());
                chestJson.addProperty("z", (Number)class_23382.method_10260());
                chests.add((JsonElement)chestJson);
            }
            json.add("chests", (JsonElement)chests);
            JsonArray jsonArray = new JsonArray();
            for (LootrunNote note : activeLootrun.notes()) {
                JsonObject noteJson = new JsonObject();
                JsonObject locationJson = new JsonObject();
                class_2374 position = note.position();
                locationJson.addProperty("x", (Number)position.method_10216());
                locationJson.addProperty("y", (Number)position.method_10214());
                locationJson.addProperty("z", (Number)position.method_10215());
                noteJson.add("location", (JsonElement)locationJson);
                String noteString = class_2561.class_2562.method_10867((class_2561)note.component(), (class_7225.class_7874)McUtils.mc().field_1724.method_56673());
                JsonElement noteElement = JsonParser.parseString((String)noteString);
                noteJson.add("note", noteElement);
                jsonArray.add((JsonElement)noteJson);
            }
            json.add("notes", (JsonElement)jsonArray);
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.now(), ZoneId.systemDefault());
            DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(Locale.US);
            json.addProperty("date", zonedDateTime.format(formatter));
            FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);
            WynntilsMod.GSON.toJson((JsonElement)json, (Appendable)writer);
            writer.close();
            return LootrunSaveResult.SAVED;
        }
        catch (IOException ex) {
            return LootrunSaveResult.ERROR_SAVING;
        }
    }
}

