/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.map;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Service;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.services.map.Label;
import com.wynntils.services.map.pois.CombatPoi;
import com.wynntils.services.map.pois.CustomPoi;
import com.wynntils.services.map.pois.LabelPoi;
import com.wynntils.services.map.pois.ServicePoi;
import com.wynntils.services.map.type.CombatKind;
import com.wynntils.services.map.type.CustomPoiProvider;
import com.wynntils.services.map.type.ServiceKind;
import com.wynntils.services.mapdata.providers.builtin.CombatListProvider;
import com.wynntils.services.mapdata.providers.builtin.PlaceListProvider;
import com.wynntils.services.mapdata.providers.builtin.ServiceListProvider;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.Texture;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PoiService
extends Service {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Label.class, (Object)new Label.LabelDeserializer()).enableComplexMapKeySerialization().create();
    public static final List<Texture> POI_ICONS = List.of(Texture.FLAG, Texture.DIAMOND, Texture.FIREBALL, Texture.SIGN, Texture.STAR, Texture.WALL, Texture.CHEST_T1, Texture.CHEST_T2, Texture.CHEST_T3, Texture.CHEST_T4, Texture.FARMING, Texture.FISHING, Texture.MINING, Texture.WOODCUTTING);
    private final Set<LabelPoi> labelPois = new HashSet<LabelPoi>();
    private final Set<ServicePoi> servicePois = new HashSet<ServicePoi>();
    private final Set<CombatPoi> combatPois = new HashSet<CombatPoi>();
    private final Set<CombatPoi> cavePois = new HashSet<CombatPoi>();
    private final Map<CustomPoiProvider, List<CustomPoi>> providedCustomPois = new ConcurrentHashMap<CustomPoiProvider, List<CustomPoi>>();
    @Persisted
    private final Storage<List<CustomPoiProvider>> customPoiProviders = new Storage(new ArrayList());

    public PoiService() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_PLACES).handleReader(this::handlePlaces);
        registry.registerDownload(UrlId.DATA_STATIC_SERVICES_CROWDSOURCED).handleReader(this::handleServices);
        registry.registerDownload(UrlId.DATA_STATIC_COMBAT_LOCATIONS).handleReader(this::handleCombat);
        registry.registerDownload(UrlId.DATA_STATIC_CAVE_INFO).handleReader(this::handleCaves);
    }

    @Override
    public void onStorageLoad(Storage<?> storage) {
        this.loadCustomPoiProviders();
    }

    public Stream<LabelPoi> getLabelPois() {
        return this.labelPois.stream();
    }

    public Stream<ServicePoi> getServicePois() {
        return this.servicePois.stream();
    }

    public Stream<CombatPoi> getCombatPois() {
        return Stream.concat(this.combatPois.stream(), this.cavePois.stream());
    }

    public List<CustomPoi> getProvidedCustomPois() {
        return ((List)this.customPoiProviders.get()).stream().filter(CustomPoiProvider::isEnabled).map(provider -> this.providedCustomPois.getOrDefault(provider, List.of())).flatMap(Collection::stream).toList();
    }

    public List<CustomPoiProvider> getCustomPoiProviders() {
        return (List)this.customPoiProviders.get();
    }

    public void addCustomPoiProvider(CustomPoiProvider poiProvider) {
        ((List)this.customPoiProviders.get()).add(poiProvider);
        this.customPoiProviders.touched();
        this.loadCustomPoiProviders();
    }

    public boolean removeCustomPoiProvider(String name) {
        Optional<CustomPoiProvider> provider = ((List)this.customPoiProviders.get()).stream().filter(p -> p.getName().equals(name)).findFirst();
        if (provider.isEmpty()) {
            return false;
        }
        ((List)this.customPoiProviders.get()).remove(provider.get());
        this.providedCustomPois.remove(provider.get());
        return true;
    }

    public boolean isPoiProvided(CustomPoi customPoi) {
        return this.getProvidedCustomPois().contains(customPoi);
    }

    private void handlePlaces(Reader reader) {
        PlacesProfile places = (PlacesProfile)GSON.fromJson(reader, PlacesProfile.class);
        for (Label label : places.labels) {
            this.labelPois.add(new LabelPoi(label));
            PlaceListProvider.registerFeature(label);
        }
    }

    private void handleServices(Reader reader) {
        Type type = new TypeToken<List<ServiceProfile>>(){}.getType();
        List serviceList = (List)GSON.fromJson(reader, type);
        for (ServiceProfile service : serviceList) {
            ServiceKind kind = ServiceKind.fromString(service.type);
            if (kind != null) {
                for (PoiLocation location : service.locations) {
                    this.servicePois.add(new ServicePoi(location, kind));
                    ServiceListProvider.registerFeature(new Location(location), kind);
                }
                continue;
            }
            WynntilsMod.warn("Unknown service type in services.json: " + service.type);
        }
    }

    private void handleCombat(Reader reader) {
        Type type = new TypeToken<List<CombatProfileList>>(){}.getType();
        List combatProfileLists = (List)GSON.fromJson(reader, type);
        for (CombatProfileList combatList : combatProfileLists) {
            CombatKind kind = CombatKind.fromString(combatList.type);
            if (kind != null && kind != CombatKind.CAVES) {
                for (CombatProfile profile : combatList.locations) {
                    this.combatPois.add(new CombatPoi(profile.coordinates, profile.name, kind));
                    CombatListProvider.registerFeature(new Location(profile.coordinates), kind, profile.name);
                }
                continue;
            }
            WynntilsMod.warn("Unknown combat type in combat.json: " + combatList.type);
        }
    }

    private void handleCaves(Reader reader) {
        Type type = new TypeToken<List<CaveProfile>>(){}.getType();
        List profiles = (List)GSON.fromJson(reader, type);
        this.cavePois.addAll(profiles.stream().map(profile -> {
            CombatListProvider.registerFeature(profile.location, CombatKind.CAVES, profile.name);
            return new CombatPoi(PoiLocation.fromLocation(profile.location), profile.name, CombatKind.CAVES);
        }).collect(Collectors.toUnmodifiableSet()));
    }

    public void loadCustomPoiProviders() {
        for (CustomPoiProvider poiProvider : (List)this.customPoiProviders.get()) {
            try {
                Managers.Net.download(poiProvider.getUrl(), poiProvider.getName()).handleJsonArray(elements -> {
                    ArrayList<CustomPoi> pois = new ArrayList<CustomPoi>();
                    for (JsonElement jsonElement : elements) {
                        CustomPoi poi = (CustomPoi)JsonManager.GSON.fromJson(jsonElement, CustomPoi.class);
                        pois.add(poi);
                    }
                    this.providedCustomPois.put(poiProvider, (List<CustomPoi>)ImmutableList.copyOf(pois));
                });
            }
            catch (IllegalArgumentException exception) {
                WynntilsMod.warn("Failed to load custom POIs from " + String.valueOf(poiProvider.getUrl()) + ": " + exception.getMessage());
            }
        }
    }

    private static class PlacesProfile {
        List<Label> labels;

        private PlacesProfile() {
        }
    }

    private static class ServiceProfile {
        String type;
        List<PoiLocation> locations;

        private ServiceProfile() {
        }
    }

    private static class CombatProfileList {
        String type;
        List<CombatProfile> locations;

        private CombatProfileList() {
        }
    }

    private static class CombatProfile {
        String name;
        PoiLocation coordinates;

        private CombatProfile() {
        }
    }

    private record CaveProfile(String type, String name, String specialInfo, String description, String length, String lengthInfo, String difficulty, int requirements, List<String> rewards, Location location) {
    }
}

