/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.map.pois;

import com.wynntils.core.text.StyledText;
import com.wynntils.services.map.Label;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.type.DisplayPriority;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class LabelPoi
implements Poi {
    private static final CustomColor AQUA = new CustomColor(0.0f, 0.8f, 0.8f);
    private static final CustomColor YELLOW = new CustomColor(1.0f, 1.0f, 0.0f);
    private static final CustomColor WHITE = new CustomColor(1.0f, 1.0f, 1.0f);
    private final PoiLocation location;
    private final Label label;

    public LabelPoi(Label label) {
        this.location = new PoiLocation(label.getX(), null, label.getZ());
        this.label = label;
    }

    @Override
    public boolean hasStaticLocation() {
        return true;
    }

    @Override
    public PoiLocation getLocation() {
        return this.location;
    }

    @Override
    public int getWidth(float mapZoom, float scale) {
        return (int)((float)FontRenderer.getInstance().getFont().method_1727(this.label.getName()) * scale);
    }

    @Override
    public int getHeight(float mapZoom, float scale) {
        Objects.requireNonNull(FontRenderer.getInstance().getFont());
        return (int)(9.0f * scale);
    }

    @Override
    public DisplayPriority getDisplayPriority() {
        return DisplayPriority.HIGH;
    }

    private float getAlphaFromScale(float zoom) {
        float alpha;
        if (zoom >= 1.0f) {
            alpha = switch (this.label.getLayer()) {
                default -> throw new MatchException(null, null);
                case Label.LabelLayer.PROVINCE -> 0.0f;
                case Label.LabelLayer.CITY -> MathUtils.map(zoom, 1.0f, 1.3f, 1.0f, 0.0f);
                case Label.LabelLayer.TOWN_OR_PLACE -> MathUtils.map(zoom, 1.5f, 2.3f, 1.0f, 0.0f);
            };
        } else {
            alpha = switch (this.label.getLayer()) {
                default -> throw new MatchException(null, null);
                case Label.LabelLayer.PROVINCE -> MathUtils.map(zoom, 0.2f, 0.25f, 1.0f, 0.0f);
                case Label.LabelLayer.CITY -> 1.0f;
                case Label.LabelLayer.TOWN_OR_PLACE -> MathUtils.map(zoom, 0.2f, 0.25f, 0.0f, 1.0f);
            };
        }
        return MathUtils.clamp(alpha, 0.0f, 1.0f) * 0.9f;
    }

    private TextShadow getTextShadow() {
        return TextShadow.OUTLINE;
    }

    private CustomColor getRenderedColor(float alpha) {
        CustomColor color = switch (this.label.getLayer()) {
            default -> throw new MatchException(null, null);
            case Label.LabelLayer.PROVINCE -> AQUA;
            case Label.LabelLayer.CITY -> YELLOW;
            case Label.LabelLayer.TOWN_OR_PLACE -> WHITE;
        };
        return color.withAlpha(alpha);
    }

    @Override
    public void renderAt(class_4587 poseStack, class_4597 bufferSource, float renderX, float renderY, boolean hovered, float scale, float zoomRenderScale, float zoomLevel, boolean showLabels) {
        Optional<Integer> level;
        float alpha = this.getAlphaFromScale(zoomRenderScale);
        if ((double)alpha < 0.01) {
            return;
        }
        float modifier = scale;
        if (hovered) {
            modifier *= 1.05f;
            alpha = 1.0f;
        }
        CustomColor color = this.getRenderedColor(alpha);
        poseStack.method_22903();
        poseStack.method_46416(renderX, renderY, (float)this.getDisplayPriority().ordinal());
        poseStack.method_22905(modifier, modifier, modifier);
        BufferedFontRenderer.getInstance().renderText(poseStack, bufferSource, StyledText.fromString(this.label.getName()), 0.0f, 0.0f, color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, this.getTextShadow(), 1.0f);
        if (hovered && (level = this.label.getLevel()).isPresent() && level.get() >= 1) {
            BufferedFontRenderer.getInstance().renderText(poseStack, bufferSource, StyledText.fromString("[Lv. " + String.valueOf(level.get()) + "]"), 0.0f, 10.0f, color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, this.getTextShadow(), 1.0f);
        }
        poseStack.method_22909();
    }

    @Override
    public String getName() {
        return this.label.getName();
    }

    public Label getLabel() {
        return this.label;
    }

    @Override
    public boolean isVisible(float zoomRenderScale, float zoomLevel) {
        return this.getAlphaFromScale(zoomRenderScale) >= 0.1f;
    }
}

