/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.map.type;

import com.wynntils.utils.render.Texture;
import java.util.Arrays;

public enum CombatKind {
    BOSS_ALTARS("Boss Altars", Texture.BOSS_ALTAR, "boss-altar"),
    CAVES("Caves", Texture.CAVE, "cave"),
    DUNGEONS("Dungeons", Texture.DUNGEON_ENTRANCE, "dungeon"),
    GRIND_SPOTS("Grind Spots", Texture.GRIND_SPOT, "grind-spot"),
    RAIDS("Raids", Texture.RAID_ENTRANCE, "raid"),
    RUNE_SHRINES("Rune Shrines", Texture.SHRINE, "shrine");

    private final String name;
    private final Texture texture;
    private final String mapDataId;

    private CombatKind(String name, Texture texture, String mapDataId) {
        this.name = name;
        this.texture = texture;
        this.mapDataId = mapDataId;
    }

    public String getName() {
        return this.name;
    }

    public Texture getIcon() {
        return this.texture;
    }

    public String getMapDataId() {
        return this.mapDataId;
    }

    public static CombatKind fromString(String str) {
        return Arrays.stream(CombatKind.values()).filter(kind -> kind.getName().equals(str)).findFirst().orElse(null);
    }
}

