/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.mapdata;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Service;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.mapdata.MapAttributesResolver;
import com.wynntils.services.mapdata.MapFeaturePoiWrapper;
import com.wynntils.services.mapdata.attributes.type.MapIcon;
import com.wynntils.services.mapdata.attributes.type.ResolvedMapAttributes;
import com.wynntils.services.mapdata.attributes.type.ResolvedMapVisibility;
import com.wynntils.services.mapdata.providers.MapDataProvider;
import com.wynntils.services.mapdata.providers.builtin.BuiltInProvider;
import com.wynntils.services.mapdata.providers.builtin.CategoriesProvider;
import com.wynntils.services.mapdata.providers.builtin.CharacterProvider;
import com.wynntils.services.mapdata.providers.builtin.CombatListProvider;
import com.wynntils.services.mapdata.providers.builtin.MapIconsProvider;
import com.wynntils.services.mapdata.providers.builtin.PlaceListProvider;
import com.wynntils.services.mapdata.providers.builtin.ServiceListProvider;
import com.wynntils.services.mapdata.providers.builtin.WaypointsProvider;
import com.wynntils.services.mapdata.providers.json.JsonProvider;
import com.wynntils.services.mapdata.type.MapCategory;
import com.wynntils.services.mapdata.type.MapFeature;
import java.io.File;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class MapDataService
extends Service {
    private static final MapDataProvider ONLINE_PLACEHOLDER_PROVIDER = new PlaceholderProvider();
    private static final String NAMELESS_CATEGORY = "Category '%s'";
    private final Deque<String> providerOrder = new LinkedList<String>();
    private final Map<String, MapDataProvider> allProviders = new HashMap<String, MapDataProvider>();
    private final Map<MapFeature, ResolvedMapAttributes> resolvedAttributesCache = new HashMap<MapFeature, ResolvedMapAttributes>();
    private final Map<String, Optional<MapIcon>> iconCache = new HashMap<String, Optional<MapIcon>>();

    public MapDataService() {
        super(List.of());
        this.createBuiltInProviders();
    }

    public Stream<MapFeature> getFeatures() {
        return this.getProviders().flatMap(MapDataProvider::getFeatures);
    }

    public Stream<Poi> getFeaturesAsPois() {
        return this.getFeatures().map(feature -> new MapFeaturePoiWrapper((MapFeature)feature, this.resolveMapAttributes((MapFeature)feature)));
    }

    public ResolvedMapAttributes resolveMapAttributes(MapFeature feature) {
        return this.resolvedAttributesCache.computeIfAbsent(feature, k -> MapAttributesResolver.resolve(feature));
    }

    public Stream<MapCategory> getCategoryDefinitions(String categoryId) {
        return this.getProviders().flatMap(MapDataProvider::getCategories).filter(p -> p.getCategoryId().equals(categoryId));
    }

    public String getCategoryName(String categoryId) {
        return this.getCategoryDefinitions(categoryId).map(MapCategory::getName).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(NAMELESS_CATEGORY.formatted(categoryId));
    }

    public Optional<MapIcon> getIcon(String iconId) {
        if (iconId.equals("none")) {
            return Optional.empty();
        }
        return this.iconCache.computeIfAbsent(iconId, k -> {
            Stream allIcons = this.getProviders().flatMap(MapDataProvider::getIcons);
            return allIcons.filter(i -> i.getIconId().equals(iconId)).findFirst();
        });
    }

    public void createBundledProvider(String id, String filename) {
        String completeId = "bundled:" + id;
        JsonProvider provider = JsonProvider.loadBundledResource(completeId, filename);
        this.registerProvider(completeId, provider);
    }

    public void createLocalProvider(String id, String filename) {
        String completeId = "local:" + id;
        JsonProvider provider = JsonProvider.loadLocalFile(completeId, new File(filename));
        this.registerProvider(completeId, provider);
    }

    public void createOnlineProvider(String id, String url) {
        String completeId = "online:" + id;
        JsonProvider.loadOnlineResource(completeId, url, this::registerProvider);
        this.registerProvider(completeId, ONLINE_PLACEHOLDER_PROVIDER);
    }

    public void prioritizeProvider(String providerId) {
        if (this.providerOrder.remove(providerId)) {
            this.providerOrder.addFirst(providerId);
        }
    }

    private void createBuiltInProviders() {
        this.registerBuiltInProvider(new CategoriesProvider());
        this.registerBuiltInProvider(new MapIconsProvider());
        this.registerBuiltInProvider(new ServiceListProvider());
        this.registerBuiltInProvider(new CombatListProvider());
        this.registerBuiltInProvider(new PlaceListProvider());
        this.registerBuiltInProvider(new CharacterProvider());
        this.registerBuiltInProvider(new WaypointsProvider());
    }

    private void registerBuiltInProvider(BuiltInProvider provider) {
        this.registerProvider("built-in:" + provider.getProviderId(), provider);
    }

    private void registerProvider(String providerId, MapDataProvider provider) {
        if (provider == null) {
            WynntilsMod.warn("Provider missing for '" + providerId + "'");
            return;
        }
        if (!this.allProviders.containsKey(providerId)) {
            this.providerOrder.addFirst(providerId);
        }
        this.allProviders.put(providerId, provider);
        this.resolvedAttributesCache.clear();
        this.iconCache.clear();
    }

    private Stream<MapDataProvider> getProviders() {
        return this.providerOrder.stream().map(this.allProviders::get);
    }

    public float calculateVisibility(ResolvedMapVisibility mapVisibility, float zoomLevel) {
        float min = mapVisibility.min();
        float max = mapVisibility.max();
        float fade = mapVisibility.fade();
        if (max < min) {
            return 0.0f;
        }
        float startFadeIn = min - fade;
        float stopFadeIn = min + fade;
        float startFadeOut = max - fade;
        float stopFadeOut = max + fade;
        if (min <= 1.0f) {
            startFadeIn = 0.0f;
            stopFadeIn = 0.0f;
        }
        if (max >= 100.0f) {
            startFadeOut = 101.0f;
            stopFadeOut = 101.0f;
        }
        if (zoomLevel < startFadeIn) {
            return 0.0f;
        }
        if (zoomLevel < stopFadeIn) {
            return (zoomLevel - startFadeIn) / (fade * 2.0f);
        }
        if (zoomLevel < startFadeOut) {
            return 1.0f;
        }
        if (zoomLevel < stopFadeOut) {
            return 1.0f - (zoomLevel - startFadeOut) / (fade * 2.0f);
        }
        return 0.0f;
    }

    private static final class PlaceholderProvider
    implements MapDataProvider {
        private PlaceholderProvider() {
        }

        @Override
        public Stream<MapFeature> getFeatures() {
            return Stream.empty();
        }

        @Override
        public Stream<MapCategory> getCategories() {
            return Stream.empty();
        }

        @Override
        public Stream<MapIcon> getIcons() {
            return Stream.empty();
        }
    }
}

