/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.resourcepack;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Service;
import com.wynntils.core.mod.ConnectionManager;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.mc.event.ConnectionEvent;
import com.wynntils.mc.event.ServerResourcePackEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class ResourcePackService
extends Service {
    private static final String PRELOADED_PACK_PREFIX = "wynntils_preloaded/";
    @Persisted
    private final Storage<Pair<UUID, String>> resourcePackIdHash = new Storage<Pair<Object, String>>(Pair.of(null, ""));
    private boolean serverHasResourcePack = false;

    public ResourcePackService() {
        super(List.of());
    }

    public void setRequestedPreloadHash(UUID id, String hash) {
        this.resourcePackIdHash.store(Pair.of(id, hash));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerResourcePackLoad(ServerResourcePackEvent.Load event) {
        class_3288 preloadedPack = this.getPreloadedPack();
        if (preloadedPack == null) {
            WynntilsMod.info("No preloaded pack, letting Minecraft handle the resource pack.");
            this.serverHasResourcePack = true;
            return;
        }
        if (preloadedPack.method_14463().equals(PRELOADED_PACK_PREFIX + event.getHash())) {
            WynntilsMod.info("Preloaded pack is up-to-date, cancelling server pack loading.");
            event.setCanceled(true);
            this.serverHasResourcePack = false;
            return;
        }
        WynntilsMod.info("Preloaded pack is outdated or wrong, clearing server pack.");
        WynntilsMod.info("Preloaded pack: " + preloadedPack.method_14463() + ", expected: " + this.getExpectedPackId());
        class_3283 resourcePackRepository = McUtils.mc().method_1520();
        ArrayList selectedIds = new ArrayList(resourcePackRepository.method_29210());
        selectedIds.remove(preloadedPack.method_14463());
        resourcePackRepository.method_14447(selectedIds);
        this.serverHasResourcePack = true;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerResourcePackClear(ServerResourcePackEvent.Clear event) {
        class_3283 resourcePackRepository = McUtils.mc().method_1520();
        class_3288 preloadedPack = this.getPreloadedPack();
        if (this.isResourcePackInfoMissing()) {
            WynntilsMod.info("No preloaded pack, or it was disabled, clearing server pack, checking if a reload should trigger.");
        } else if (preloadedPack == null) {
            WynntilsMod.info("No preloaded pack, clearing server pack, trying to preload a new pack.");
        } else if (!preloadedPack.method_14463().equals(this.getExpectedPackId())) {
            WynntilsMod.info("Preloaded pack is outdated, clearing server pack, trying to preload a new pack.");
        } else {
            WynntilsMod.info("Preloaded pack is up-to-date, no-op.");
            return;
        }
        resourcePackRepository.method_14445();
        boolean changeMade = this.preloadResourcePack();
        if (!changeMade) {
            WynntilsMod.info("No changes to preloaded packs, clearing server pack, no reload needed.");
            return;
        }
        if (this.serverHasResourcePack) {
            WynntilsMod.info("Preloaded pack updated, reloading resource packs is done by Minecraft.");
            return;
        }
        WynntilsMod.info("Triggering a resource pack reload, as the server had no resource packs, and a change was made.");
        McUtils.mc().method_1521();
    }

    @SubscribeEvent
    public void onConnect(ConnectionEvent.ConnectingEvent event) {
        this.serverHasResourcePack = false;
        if (Managers.Connection.getConnectionState() != ConnectionManager.ConnectionState.DISCONNECTED) {
            return;
        }
        WynntilsMod.info("Joined a non-Wynncraft server, clearing preloaded pack.");
        class_3283 resourcePackRepository = McUtils.mc().method_1520();
        ArrayList<String> selectedIds = new ArrayList<String>(resourcePackRepository.method_29210());
        boolean anyRemoved = selectedIds.removeIf(id -> id.startsWith(PRELOADED_PACK_PREFIX));
        resourcePackRepository.method_14447(selectedIds);
        if (anyRemoved) {
            WynntilsMod.info("Preloaded pack removed, reloading resource packs.");
            McUtils.mc().method_1521();
        }
    }

    public boolean preloadResourcePack() {
        class_3283 resourcePackRepository = McUtils.mc().method_1520();
        ArrayList<String> selectedIds = new ArrayList<String>(resourcePackRepository.method_29210());
        boolean anyRemoved = selectedIds.removeIf(id -> id.startsWith(PRELOADED_PACK_PREFIX));
        if (this.isResourcePackInfoMissing()) {
            resourcePackRepository.method_14447(selectedIds);
            return anyRemoved;
        }
        class_3288 lastRequiredPack = selectedIds.stream().map(arg_0 -> ((class_3283)resourcePackRepository).method_14449(arg_0)).filter(Objects::nonNull).filter(class_3288::method_14464).reduce((first, second) -> second).orElse(null);
        int positionToInject = lastRequiredPack == null ? 0 : selectedIds.indexOf(lastRequiredPack.method_14463()) + 1;
        for (class_3288 pack : resourcePackRepository.method_14441()) {
            if (!pack.method_14463().equals(this.getExpectedPackId())) continue;
            if (selectedIds.contains(pack.method_14463())) break;
            selectedIds.add(positionToInject, pack.method_14463());
            resourcePackRepository.method_14447(selectedIds);
            return true;
        }
        WynntilsMod.warn("Could not find the preload target pack to select it.");
        resourcePackRepository.method_14447(selectedIds);
        return anyRemoved;
    }

    public boolean isPreloadedPackSelected() {
        return McUtils.mc().method_1520().method_29210().contains(this.getExpectedPackId());
    }

    private class_3288 getPreloadedPack() {
        if (this.isResourcePackInfoMissing()) {
            return null;
        }
        class_3283 resourcePackRepository = McUtils.mc().method_1520();
        for (class_3288 pack : resourcePackRepository.method_14444()) {
            if (!pack.method_14463().equals(this.getExpectedPackId())) continue;
            return pack;
        }
        return null;
    }

    private boolean isResourcePackInfoMissing() {
        Pair resourceInfo = (Pair)this.resourcePackIdHash.get();
        return resourceInfo.key() == null || resourceInfo.value() == null || ((String)resourceInfo.value()).isEmpty();
    }

    private String getExpectedPackId() {
        return PRELOADED_PACK_PREFIX + (String)((Pair)this.resourcePackIdHash.get()).value();
    }
}

