/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.resourcepack;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.mc.McUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1066;
import net.minecraft.class_2561;
import net.minecraft.class_3258;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_9224;
import net.minecraft.class_9225;

public final class WynntilsResourceProvider
implements class_3285 {
    private static final String PRELOADED_PACK_PREFIX = "wynntils_preloaded/";
    private static final Pattern WYNNCRAFT_PACK_PATTERN = Pattern.compile("\u00a7(#.{8}|.)Wynncraft Resource Pack \u00a77.+", 32);
    private static final Path MINECRAFT_RESOURCE_PACKS_PATH = McUtils.mc().field_1697.toPath().resolve("downloads");
    private static final class_9225 WYNNTILS_PRELOADED_PACK_CONFIG = new class_9225(false, class_3288.class_3289.field_14280, false);
    private static final class_5352 WYNNTILS_PRELOADED_PACK_SOURCE = class_5352.method_45281(component -> component.method_27661().method_10852((class_2561)class_2561.method_43470((String)" (Wynntils)")), (boolean)true);

    public void method_14453(Consumer<class_3288> onLoad) {
        try (Stream<Path> paths = Files.walk(MINECRAFT_RESOURCE_PACKS_PATH, 2, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                class_3258.class_8615 resourcesSupplier;
                String fileName = path.getFileName().toString();
                if (class_1066.method_55518((String)fileName) == null) {
                    return;
                }
                class_9224 packLocationInfo = new class_9224(PRELOADED_PACK_PREFIX + fileName, (class_2561)class_2561.method_43470((String)"Wynncraft Pack"), WYNNTILS_PRELOADED_PACK_SOURCE, Optional.empty());
                class_3288 pack = class_3288.method_45275((class_9224)packLocationInfo, (class_3288.class_7680)(resourcesSupplier = new class_3258.class_8615(path)), (class_3264)class_3264.field_14188, (class_9225)WYNNTILS_PRELOADED_PACK_CONFIG);
                if (pack == null) {
                    WynntilsMod.warn("Failed to load resource pack: " + fileName);
                    return;
                }
                StyledText packDescription = StyledText.fromComponent(pack.method_14459());
                if (packDescription.matches(WYNNCRAFT_PACK_PATTERN)) {
                    onLoad.accept(pack);
                }
            });
        }
        catch (IOException e) {
            WynntilsMod.error("Failed to load resource pack", e);
        }
    }
}

