/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils;

import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.UnsignedByte;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class UnsignedByteUtils {
    public static UnsignedByte[] fromBitArray(boolean[] values) {
        assert (values.length % 8 == 0);
        UnsignedByte[] bytes = new UnsignedByte[values.length / 8];
        for (int i = 0; i < values.length; i += 8) {
            byte value = 0;
            for (int j = 0; j < 8; ++j) {
                value = (byte)(value | (values[i + j] ? 1 : 0) << 7 - j);
            }
            bytes[i / 8] = UnsignedByte.of(value);
        }
        return bytes;
    }

    public static boolean[] toBitArray(UnsignedByte[] unsignedBytes) {
        boolean[] values = new boolean[unsignedBytes.length * 8];
        for (int i = 0; i < unsignedBytes.length; ++i) {
            byte value = unsignedBytes[i].toByte();
            for (int j = 0; j < 8; ++j) {
                values[i * 8 + j] = (value >> 7 - j & 1) == 1;
            }
        }
        return values;
    }

    public static UnsignedByte[] encodeString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            throw new IllegalArgumentException("String contains non-ASCII characters");
        }
        UnsignedByte[] bytes = new UnsignedByte[string.length() + 1];
        byte[] asciiBytes = string.getBytes(StandardCharsets.US_ASCII);
        for (int i = 0; i < asciiBytes.length; ++i) {
            bytes[i] = UnsignedByte.of(asciiBytes[i]);
        }
        bytes[bytes.length - 1] = UnsignedByte.of((byte)0);
        return bytes;
    }

    public static String decodeString(List<UnsignedByte> bytes) {
        byte[] asciiBytes = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            asciiBytes[i] = bytes.get(i).toByte();
        }
        return new String(asciiBytes, StandardCharsets.US_ASCII);
    }

    public static UnsignedByte[] encodeVariableSizedInteger(long value) {
        value = value << 1 ^ value >> 63;
        int numBytes = 1;
        long temp = value;
        while ((temp >>>= 7) != 0L) {
            ++numBytes;
        }
        UnsignedByte[] bytes = new UnsignedByte[numBytes];
        for (int i = 0; i < numBytes; ++i) {
            byte nextByte = (byte)(value & 0x7FL);
            value >>>= 7;
            if (i != numBytes - 1) {
                nextByte = (byte)(nextByte | 0x80);
            }
            bytes[i] = UnsignedByte.of(nextByte);
        }
        return bytes;
    }

    public static long decodeVariableSizedInteger(ArrayReader<UnsignedByte> byteReader) {
        long value = 0L;
        int numBytes = 0;
        while ((byteReader.peek().toByte() & 0x80) != 0) {
            value |= (long)(byteReader.read().toByte() & 0x7F) << 7 * numBytes;
            ++numBytes;
        }
        return (value |= (long)(byteReader.read().toByte() & 0x7F) << 7 * numBytes) >>> 1 ^ -(value & 1L);
    }
}

