/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.colors;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.wynntils.utils.MathUtils;
import java.awt.Color;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import net.minecraft.class_124;

public record CustomColor(int r, int g, int b, int a) {
    public static final CustomColor NONE = new CustomColor(-1, -1, -1, -1);
    private static final Pattern HEX_PATTERN = Pattern.compile("#?([0-9a-fA-F]{6})([0-9a-fA-F]{2})?");
    private static final Pattern STRING_PATTERN = Pattern.compile("rgba\\((\\d+),(\\d+),(\\d+),(\\d+)\\)");
    private static final Map<String, CustomColor> REGISTERED_HASHED_COLORS = new HashMap<String, CustomColor>();

    public CustomColor(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public CustomColor(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public CustomColor(float r, float g, float b, float a) {
        this((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public CustomColor(CustomColor color) {
        this(color.r, color.g, color.b, color.a);
    }

    public CustomColor(CustomColor color, int alpha) {
        this(color.r, color.g, color.b, alpha);
    }

    public CustomColor(String toParse) {
        this(CustomColor.fromStringWithHex(toParse).r(), CustomColor.fromStringWithHex(toParse).g(), CustomColor.fromStringWithHex(toParse).b(), CustomColor.fromStringWithHex(toParse).a());
    }

    public static CustomColor fromStringWithHex(String toParse) {
        String noSpace = toParse.replace(" ", "");
        CustomColor fromString = CustomColor.fromString(noSpace);
        if (fromString != NONE) {
            return fromString;
        }
        CustomColor fromHex = CustomColor.fromHexString(noSpace);
        if (fromHex != NONE) {
            return fromHex;
        }
        throw new RuntimeException("Failed to parse CustomColor");
    }

    public static CustomColor fromChatFormatting(class_124 cf) {
        return CustomColor.fromInt(cf.method_532() | 0xFF000000);
    }

    public static CustomColor fromInt(int num) {
        if ((num & 0xFF000000) == 0) {
            num |= 0xFF000000;
        }
        return new CustomColor(num >> 16 & 0xFF, num >> 8 & 0xFF, num & 0xFF, num >> 24 & 0xFF);
    }

    public static CustomColor fromHSV(float h, float s, float v, float a) {
        a = MathUtils.clamp(a, 0.0f, 1.0f);
        if (v <= 0.0f) {
            return new CustomColor(0.0f, 0.0f, 0.0f, a);
        }
        if (v > 1.0f) {
            v = 1.0f;
        }
        if (s <= 0.0f) {
            return new CustomColor(v, v, v, a);
        }
        if (s > 1.0f) {
            s = 1.0f;
        }
        float vh = (h % 1.0f + 1.0f) * 6.0f % 6.0f;
        int vi = MathUtils.floor(vh);
        float v1 = v * (1.0f - s);
        float v2 = v * (1.0f - s * (vh - (float)vi));
        float v3 = v * (1.0f - s * (1.0f - (vh - (float)vi)));
        return switch (vi) {
            case 0 -> new CustomColor(v, v3, v1, a);
            case 1 -> new CustomColor(v2, v, v1, a);
            case 2 -> new CustomColor(v1, v, v3, a);
            case 3 -> new CustomColor(v1, v2, v, a);
            case 4 -> new CustomColor(v3, v1, v, a);
            default -> new CustomColor(v, v1, v2, a);
        };
    }

    public static CustomColor fromHexString(String hex) {
        Matcher hexMatcher = HEX_PATTERN.matcher(hex.trim());
        if (!hexMatcher.matches()) {
            return NONE;
        }
        if (hexMatcher.group(2) == null) {
            return CustomColor.fromInt(Integer.parseInt(hexMatcher.group(1), 16)).withAlpha(255);
        }
        return CustomColor.fromInt(Integer.parseInt(hexMatcher.group(1), 16)).withAlpha(Integer.parseInt(hexMatcher.group(2), 16));
    }

    public static CustomColor fromString(String string) {
        Matcher stringMatcher = STRING_PATTERN.matcher(string.trim());
        if (!stringMatcher.matches()) {
            return NONE;
        }
        return new CustomColor(Integer.parseInt(stringMatcher.group(1)), Integer.parseInt(stringMatcher.group(2)), Integer.parseInt(stringMatcher.group(3)), Integer.parseInt(stringMatcher.group(4)));
    }

    public static CustomColor colorForStringHash(String input) {
        if (REGISTERED_HASHED_COLORS.containsKey(input)) {
            return REGISTERED_HASHED_COLORS.get(input);
        }
        CRC32 crc32 = new CRC32();
        crc32.update(input.getBytes(StandardCharsets.UTF_8));
        Random random = new Random(crc32.getValue());
        float minS = 0.5f;
        float minV = 0.75f;
        CustomColor color = CustomColor.fromHSV(random.nextFloat(), 0.5f + 0.5f * random.nextFloat(), 0.75f + 0.25f * random.nextFloat(), 1.0f);
        REGISTERED_HASHED_COLORS.put(input, color);
        return color;
    }

    public CustomColor withAlpha(int a) {
        return new CustomColor(this, a);
    }

    public CustomColor withAlpha(float a) {
        return new CustomColor(this, (int)(a * 255.0f));
    }

    public float[] asHSB() {
        return Color.RGBtoHSB(this.r, this.g, this.b, null);
    }

    public CustomColor hueShift(float degree) {
        float[] hsb = this.asHSB();
        float hue = hsb[0] + degree;
        return CustomColor.fromHSV(hue, hsb[1], hsb[2], this.a);
    }

    public CustomColor saturationShift(float degree) {
        float[] hsb = this.asHSB();
        float saturation = hsb[1] + degree;
        return CustomColor.fromHSV(hsb[0], saturation, hsb[2], this.a);
    }

    public CustomColor brightnessShift(float degree) {
        float[] hsb = this.asHSB();
        float brightness = hsb[2] + degree;
        return CustomColor.fromHSV(hsb[0], hsb[1], brightness, this.a);
    }

    public int asInt() {
        int a = Math.min(this.a, 255);
        int r = Math.min(this.r, 255);
        int g = Math.min(this.g, 255);
        int b = Math.min(this.b, 255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public float[] asFloatArray() {
        return new float[]{(float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f};
    }

    public String toHexString() {
        return "#" + String.format("%08x", this.r << 24 | this.g << 16 | this.b << 8 | this.a);
    }

    @Override
    public String toString() {
        return this.toHexString();
    }

    public static class CustomColorSerializer
    implements JsonSerializer<CustomColor>,
    JsonDeserializer<CustomColor> {
        public CustomColor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            CustomColor customColor = CustomColor.fromHexString(json.getAsString());
            return customColor == NONE ? CustomColor.fromString(json.getAsString()) : customColor;
        }

        public JsonElement serialize(CustomColor src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.toString());
        }
    }
}

