/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc;

import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.WynnUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public final class ComponentUtils {
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("(\u00a7[1-9a-f])+");
    private static final int RAINBOW_CYCLE_TIME = 5000;
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\n");
    private static final class_2960 PILL_FONT = class_2960.method_60656((String)"banner/pill");
    private static final class_2583 BACKGROUND_STYLE = class_2583.field_24360.method_27704(PILL_FONT).method_10977(class_124.field_1075);
    private static final class_2583 FOREGROUND_STYLE = class_2583.field_24360.method_27704(PILL_FONT).method_10977(class_124.field_1074);
    private static final class_2561 WYNNTILS_BACKGROUND_PILL = class_2561.method_43470((String)"\ue060\udaff\udfff\ue046\udaff\udfff\ue048\udaff\udfff\ue03d\udaff\udfff\ue03d\udaff\udfff\ue043\udaff\udfff\ue038\udaff\udfff\ue03b\udaff\udfff\ue042\udaff\udfff\ue062\udaff\udfd0").method_27696(BACKGROUND_STYLE);
    private static final class_2561 WYNNTILS_FOREGROUND_PILL = class_2561.method_43470((String)"\ue016\ue018\ue00d\ue00d\ue013\ue008\ue00b\ue012\udb00\udc02 ").method_27696(FOREGROUND_STYLE);

    public static List<class_2561> stripDuplicateBlank(List<class_2561> lore) {
        String line;
        class_2561 loreLine;
        int index;
        ArrayList<class_2561> newLore = new ArrayList<class_2561>();
        boolean oldBlank = false;
        for (index = 0; index < lore.size(); ++index) {
            loreLine = lore.get(index);
            line = WynnUtils.normalizeBadString(loreLine.getString());
            newLore.add(loreLine);
            if (!line.isEmpty()) continue;
            oldBlank = true;
            break;
        }
        if (!oldBlank) {
            return newLore;
        }
        while (index < lore.size()) {
            loreLine = lore.get(index);
            line = WynnUtils.normalizeBadString(loreLine.getString());
            if (!oldBlank || !line.isEmpty()) {
                oldBlank = line.isEmpty();
                newLore.add(loreLine);
            }
            ++index;
        }
        return newLore;
    }

    public static class_2583 getLastPartCodes(StyledText lastPart) {
        StyledTextPart lastTextPart = lastPart.getLastPart();
        if (lastTextPart == null) {
            return class_2583.field_24360;
        }
        return lastTextPart.getPartStyle().getStyle();
    }

    public static class_2561 formattedTextToComponent(class_5348 formattedText) {
        class_5250 component = class_2561.method_43470((String)"");
        formattedText.method_27658((style, string) -> {
            component.method_10852((class_2561)class_2561.method_43470((String)string).method_27696(style));
            return Optional.empty();
        }, class_2583.field_24360);
        return component;
    }

    public static int getOptimalTooltipWidth(List<class_2561> tooltips, int screenWidth, int mouseX) {
        int tooltipX = mouseX + 12;
        int tooltipWidth = tooltips.stream().mapToInt(arg_0 -> ((class_327)McUtils.mc().field_1772).method_27525(arg_0)).max().orElse(0);
        if (tooltipX + tooltipWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipWidth) < 4) {
            tooltipWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
        }
        return tooltipWidth;
    }

    public static List<class_2561> wrapTooltips(List<class_2561> tooltips, int maxWidth) {
        return tooltips.stream().flatMap(x -> ComponentUtils.splitComponent(x, maxWidth).stream()).toList();
    }

    public static List<class_2561> splitComponent(class_2561 component, int maxWidth) {
        List<class_2561> split = McUtils.mc().field_1772.method_27527().method_27495((class_5348)component, maxWidth, class_2583.field_24360).stream().map(ComponentUtils::formattedTextToComponent).collect(Collectors.toList());
        if (split.isEmpty()) {
            split.add((class_2561)class_2561.method_43470((String)""));
        }
        return split;
    }

    public static class_5250 makeRainbowStyle(String name, boolean useShader) {
        if (useShader) {
            return class_2561.method_43470((String)name).method_54663(CommonColors.RAINBOW.asInt()).method_27692(class_124.field_1067);
        }
        class_5250 newName = class_2561.method_43470((String)"").method_27692(class_124.field_1067);
        int time = (int)(System.currentTimeMillis() % 5000L);
        for (int i = 0; i < name.length(); ++i) {
            int hue = (time + i * 5000 / 7) % 5000;
            class_2583 color = class_2583.field_24360.method_36139(Color.HSBtoRGB((float)hue / 5000.0f, 0.8f, 0.8f)).method_10978(Boolean.valueOf(false));
            newName.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(name.charAt(i))).method_10862(color));
        }
        return newName;
    }

    public static class_5250 makeObfuscated(String name, float obfuscationChanceStart, float obfuscationChanceEnd) {
        class_5250 newName = class_2561.method_43470((String)"").method_27695(new class_124[]{class_124.field_1067, class_124.field_1079});
        boolean obfuscated = Math.random() < (double)obfuscationChanceStart;
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < name.length() - 1; ++i) {
            current.append(name.charAt(i));
            float chance = MathUtils.lerp(obfuscationChanceStart, obfuscationChanceEnd, (float)(i + 1) / (float)(name.length() - 1));
            if (!obfuscated && Math.random() < (double)chance) {
                newName.method_10852((class_2561)class_2561.method_43470((String)current.toString()));
                current = new StringBuilder();
                obfuscated = true;
                continue;
            }
            if (!obfuscated || !(Math.random() > (double)chance)) continue;
            newName.method_10852((class_2561)class_2561.method_43470((String)current.toString()).method_27696(class_2583.field_24360.method_36141(Boolean.valueOf(true))));
            current = new StringBuilder();
            obfuscated = false;
        }
        current.append(name.charAt(name.length() - 1));
        if (obfuscated) {
            newName.method_10852((class_2561)class_2561.method_43470((String)current.toString()).method_27696(class_2583.field_24360.method_36141(Boolean.valueOf(true))));
        } else {
            newName.method_10852((class_2561)class_2561.method_43470((String)current.toString()));
        }
        return newName;
    }

    public static class_5250 addWynntilsPillHeader(class_2561 component) {
        return class_2561.method_43473().method_10852(WYNNTILS_BACKGROUND_PILL).method_10852(WYNNTILS_FOREGROUND_PILL).method_10852(component);
    }
}

