/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public final class LoreUtils {
    public static LinkedList<StyledText> getLore(class_1799 itemStack) {
        List lines = ((class_9290)itemStack.method_57825(class_9334.field_49632, (Object)class_9290.field_49340)).comp_2400();
        return lines.stream().map(StyledText::fromComponent).collect(LinkedList::new, LinkedList::add, LinkedList::addAll);
    }

    public static Matcher matchLoreLine(class_1799 itemStack, int startLineNum, Pattern pattern) {
        StyledText line;
        LinkedList<StyledText> lore = LoreUtils.getLore(itemStack);
        Matcher matcher = StyledText.EMPTY.getMatcher(pattern);
        for (int i = startLineNum; i < Math.min(startLineNum + 6, lore.size()) && !(matcher = pattern.matcher((line = lore.get(i)).getString())).matches(); ++i) {
        }
        return matcher;
    }

    public static StyledText getStringLore(class_1799 itemStack) {
        return StyledText.concat(LoreUtils.getLore(itemStack));
    }

    public static List<class_2561> getTooltipLines(class_1799 itemStack) {
        class_1836.class_1837 flag = McUtils.options().field_1827 ? class_1836.field_41071 : class_1836.field_41070;
        return itemStack.method_7950(class_1792.class_9635.method_59528((class_1937)McUtils.mc().field_1687), (class_1657)McUtils.player(), (class_1836)flag);
    }

    public static List<class_2561> appendTooltip(class_1799 itemStack, List<class_2561> baseTooltip, List<class_2561> tooltipAddon) {
        int advancedStartLine;
        if (McUtils.options().field_1827 && (advancedStartLine = LoreUtils.getAdvancedStartLine(baseTooltip, itemStack)) != -1) {
            ArrayList<class_2561> newTooltip = new ArrayList<class_2561>();
            for (int i = 0; i < baseTooltip.size(); ++i) {
                if (i == advancedStartLine) {
                    newTooltip.addAll(tooltipAddon);
                }
                newTooltip.add(baseTooltip.get(i));
            }
            return newTooltip;
        }
        ArrayList<class_2561> newTooltip = new ArrayList<class_2561>(baseTooltip);
        newTooltip.addAll(tooltipAddon);
        return newTooltip;
    }

    private static int getAdvancedStartLine(List<class_2561> baseTooltip, class_1799 itemStack) {
        class_5250 typeLine = class_2561.method_43470((String)class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString()).method_27692(class_124.field_1063);
        class_5250 damagedLine = class_2561.method_43469((String)"item.durability", (Object[])new Object[]{itemStack.method_7936() - itemStack.method_7919(), itemStack.method_7936()});
        int advancedStartLine = -1;
        for (int i = baseTooltip.size() - 1; i >= Math.max(0, baseTooltip.size() - 4); --i) {
            class_2561 line = baseTooltip.get(i);
            if (!line.equals((Object)typeLine)) continue;
            advancedStartLine = i;
            break;
        }
        if (advancedStartLine > 1 && baseTooltip.get(advancedStartLine - 1).equals((Object)damagedLine)) {
            --advancedStartLine;
        }
        return advancedStartLine;
    }

    public static JsonObject getJsonFromIngameLore(class_1799 itemStack) {
        String rawLore = StringUtils.substringBeforeLast(LoreUtils.getStringLore(itemStack).getString(), "}") + "}";
        try {
            return JsonParser.parseString((String)rawLore).getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            return new JsonObject();
        }
    }
}

