/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc.type;

import com.wynntils.utils.mc.type.Location;
import java.util.Objects;
import java.util.Optional;

public class PoiLocation {
    private static final int DEFAULT_Y = 64;
    private final int x;
    private final Integer y;
    private final int z;

    public PoiLocation(int x, Integer y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public Optional<Integer> getY() {
        return Optional.ofNullable(this.y);
    }

    public int getZ() {
        return this.z;
    }

    public Location asLocation() {
        return new Location(this.x, this.y == null ? 64 : this.y, this.z);
    }

    public String toString() {
        if (this.y == null) {
            return "[" + this.x + ", " + this.z + "]";
        }
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public String asChatCoordinates() {
        return this.x + " " + this.y + " " + this.z;
    }

    public static PoiLocation fromLocation(Location location) {
        if (location == null) {
            return null;
        }
        return new PoiLocation(location.x, location.y, location.z);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PoiLocation that = (PoiLocation)other;
        return this.x == that.x && Objects.equals(this.y, that.y) && this.z == that.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }
}

