/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.render;

import com.wynntils.core.text.StyledText;
import com.wynntils.mc.mixin.accessors.MinecraftAccessor;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_9799;

public final class FontRenderer {
    private static final class_4597.class_4598 BUFFER_SOURCE = class_4597.method_22991((class_9799)new class_9799(256));
    private static final FontRenderer INSTANCE = new FontRenderer();
    private final class_327 font = ((MinecraftAccessor)McUtils.mc()).getFont();
    private static final double HALF_PI = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;
    private static final int NEWLINE_OFFSET = 10;

    private FontRenderer() {
    }

    public static FontRenderer getInstance() {
        return INSTANCE;
    }

    public class_327 getFont() {
        return this.font;
    }

    public void renderText(class_4587 poseStack, StyledText text, float x, float y, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale, class_327.class_6415 displayMode) {
        BufferedFontRenderer.getInstance().renderText(poseStack, (class_4597)BUFFER_SOURCE, text, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, textScale, displayMode);
        BUFFER_SOURCE.method_22993();
    }

    public void renderText(class_4587 poseStack, StyledText text, float x, float y, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale) {
        this.renderText(poseStack, text, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, textScale, class_327.class_6415.field_33994);
    }

    public void renderText(class_4587 poseStack, StyledText text, float x, float y, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow) {
        this.renderText(poseStack, text, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, 1.0f);
    }

    public void renderAlignedTextInBox(class_4587 poseStack, StyledText[] lines, float x1, float x2, float y1, float y2, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow, float textScale) {
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        ArrayList<StyledText> adjustedLines = new ArrayList<StyledText>();
        for (StyledText line : lines) {
            if (maxWidth == 0.0f || (float)this.font.method_27525((class_5348)line.getComponent()) < maxWidth / textScale) {
                adjustedLines.add(line);
                continue;
            }
            List parts = this.font.method_27527().method_27495((class_5348)line.getComponent(), (int)(maxWidth / textScale), class_2583.field_24360);
            StyledText lastPart = StyledText.EMPTY;
            for (class_5348 part : parts) {
                StyledText text;
                class_2583 lastStyle = ComponentUtils.getLastPartCodes(lastPart);
                lastPart = text = StyledText.fromComponent((class_2561)class_2561.method_43470((String)"").method_27696(lastStyle)).append(StyledText.fromComponent(ComponentUtils.formattedTextToComponent(part)));
                adjustedLines.add(text);
            }
        }
        float calculatedTextHeight = (float)((adjustedLines.size() - 1) * lineHeight) * textScale;
        float renderX = switch (horizontalAlignment) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> x1;
            case HorizontalAlignment.CENTER -> (x1 + x2) / 2.0f;
            case HorizontalAlignment.RIGHT -> x2;
        };
        float renderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> y1;
            case VerticalAlignment.MIDDLE -> (y1 + y2) / 2.0f - calculatedTextHeight / 2.0f;
            case VerticalAlignment.BOTTOM -> y2 - calculatedTextHeight;
        };
        float lineOffset = 0.0f;
        for (StyledText text : adjustedLines) {
            this.renderText(poseStack, text, renderX, renderY + lineOffset, customColor, horizontalAlignment, verticalAlignment, textShadow, textScale);
            lineOffset += (float)lineHeight * textScale;
        }
    }

    public void renderAlignedTextInBox(class_4587 poseStack, StyledText text, float x1, float x2, float y1, float y2, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow, float textScale) {
        this.renderAlignedTextInBox(poseStack, new StyledText[]{text}, x1, x2, y1, y2, maxWidth, customColor, horizontalAlignment, verticalAlignment, textShadow, textScale);
    }

    public void renderAlignedTextInBox(class_4587 poseStack, StyledText text, float x1, float x2, float y1, float y2, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow) {
        this.renderAlignedTextInBox(poseStack, new StyledText[]{text}, x1, x2, y1, y2, maxWidth, customColor, horizontalAlignment, verticalAlignment, textShadow, 1.0f);
    }

    public void renderAlignedHighlightedTextInBox(class_4587 poseStack, StyledText text, float x1, float x2, float y1, float y2, float maxWidth, CustomColor textColor, CustomColor backgroundColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        float renderX = switch (horizontalAlignment) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> x1;
            case HorizontalAlignment.CENTER -> (x1 + x2) / 2.0f;
            case HorizontalAlignment.RIGHT -> x2;
        };
        float renderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> y1;
            case VerticalAlignment.MIDDLE -> (y1 + y2) / 2.0f;
            case VerticalAlignment.BOTTOM -> y2;
        };
        float cursorRenderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> renderY - 2.0f;
            case VerticalAlignment.MIDDLE -> {
                Objects.requireNonNull(this.font);
                yield renderY - 9.0f / 2.0f - 2.0f;
            }
            case VerticalAlignment.BOTTOM -> {
                Objects.requireNonNull(this.font);
                yield renderY - 9.0f + 2.0f;
            }
        };
        float f = this.font.method_27525((class_5348)text.getComponent());
        Objects.requireNonNull(this.font);
        RenderUtils.drawRect(poseStack, backgroundColor, renderX, cursorRenderY, 0.0f, f, 9 + 2);
        this.renderAlignedTextInBox(poseStack, new StyledText[]{text}, x1, x2, y1, y2, maxWidth, textColor, horizontalAlignment, verticalAlignment, TextShadow.NONE, 1.0f);
    }

    public void renderAlignedTextInBox(class_4587 poseStack, StyledText text, float x1, float x2, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, TextShadow textShadow) {
        this.renderAlignedTextInBox(poseStack, new StyledText[]{text}, x1, x2, y, y, maxWidth, customColor, horizontalAlignment, VerticalAlignment.TOP, textShadow, 1.0f);
    }

    public void renderAlignedTextInBox(class_4587 poseStack, StyledText text, float x, float y1, float y2, float maxWidth, CustomColor customColor, VerticalAlignment verticalAlignment, TextShadow textShadow) {
        this.renderAlignedTextInBox(poseStack, new StyledText[]{text}, x, x, y1, y2, maxWidth, customColor, HorizontalAlignment.LEFT, verticalAlignment, textShadow, 1.0f);
    }

    private void renderText(class_4587 poseStack, StyledText text, float x, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale, class_327.class_6415 displayMode) {
        if (text == null) {
            return;
        }
        if (maxWidth == 0.0f || (float)this.font.method_27525((class_5348)text.getComponent()) / textScale < maxWidth) {
            this.renderText(poseStack, text, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, textScale, displayMode);
            return;
        }
        List parts = this.font.method_27527().method_27495((class_5348)text.getComponent(), (int)(maxWidth / textScale), class_2583.field_24360);
        StyledText lastPart = StyledText.EMPTY;
        for (int i = 0; i < parts.size(); ++i) {
            StyledText part;
            class_2583 lastStyle = ComponentUtils.getLastPartCodes(lastPart);
            lastPart = part = StyledText.fromComponent((class_2561)class_2561.method_43470((String)"").method_27696(lastStyle)).append(StyledText.fromComponent(ComponentUtils.formattedTextToComponent((class_5348)parts.get(i))));
            Objects.requireNonNull(this.font);
            this.renderText(poseStack, part, x, y + (float)(i * 9) * textScale, customColor, horizontalAlignment, verticalAlignment, shadow, textScale, displayMode);
        }
    }

    public void renderText(class_4587 poseStack, StyledText text, float x, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale) {
        this.renderText(poseStack, text, x, y, maxWidth, customColor, horizontalAlignment, verticalAlignment, shadow, textScale, class_327.class_6415.field_33994);
    }

    public void renderText(class_4587 poseStack, StyledText text, float x, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, class_327.class_6415 displayMode) {
        this.renderText(poseStack, text, x, y, maxWidth, customColor, horizontalAlignment, verticalAlignment, shadow, 1.0f, displayMode);
    }

    public void renderText(class_4587 poseStack, StyledText text, float x, float y, float maxWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow) {
        this.renderText(poseStack, text, x, y, maxWidth, customColor, horizontalAlignment, verticalAlignment, shadow, class_327.class_6415.field_33994);
    }

    public void renderScrollingText(class_4587 poseStack, StyledText styledText, float x, float y, float renderWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow, float textScale) {
        int textLength = (int)((float)(this.font.method_27525((class_5348)styledText.getComponent()) + 1) * textScale);
        if ((float)textLength > renderWidth) {
            float maxScrollOffset = switch (horizontalAlignment) {
                case HorizontalAlignment.CENTER -> -((float)textLength / 2.0f) + renderWidth / 2.0f;
                case HorizontalAlignment.RIGHT -> 0.0f;
                default -> (float)textLength - renderWidth;
            };
            double currentTimeInSeconds = (double)class_156.method_658() / 1000.0;
            double scrollFactor = Math.max((double)maxScrollOffset * 0.5, 3.0);
            double scrollPosition = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * currentTimeInSeconds / scrollFactor)) / 2.0 + 0.5;
            float startOffset = switch (horizontalAlignment) {
                case HorizontalAlignment.CENTER -> (float)textLength / 2.0f - renderWidth / 2.0f;
                case HorizontalAlignment.RIGHT -> renderWidth - (float)textLength;
                default -> 0.0f;
            };
            double scrollOffset = class_3532.method_16436((double)scrollPosition, (double)startOffset, (double)maxScrollOffset);
            float scissorX = switch (horizontalAlignment) {
                default -> throw new MatchException(null, null);
                case HorizontalAlignment.LEFT -> x;
                case HorizontalAlignment.CENTER -> x - renderWidth / 2.0f;
                case HorizontalAlignment.RIGHT -> x - renderWidth;
            };
            float scissorY = switch (verticalAlignment) {
                default -> throw new MatchException(null, null);
                case VerticalAlignment.TOP -> y;
                case VerticalAlignment.MIDDLE -> {
                    Objects.requireNonNull(this.font);
                    yield y - 9.0f / 2.0f - 1.0f;
                }
                case VerticalAlignment.BOTTOM -> {
                    Objects.requireNonNull(this.font);
                    yield y - 9.0f - 1.0f;
                }
            };
            float f = (int)scissorX;
            float f2 = (int)scissorY;
            float f3 = (int)renderWidth;
            Objects.requireNonNull(this.font);
            RenderUtils.createRectMask(poseStack, f, f2, f3, (int)((float)(9 + 1) * textScale));
            this.renderText(poseStack, styledText, x - (float)((int)scrollOffset), y, customColor, horizontalAlignment, verticalAlignment, shadow, textScale);
            RenderUtils.clearMask();
        } else {
            this.renderText(poseStack, styledText, x, y, customColor, horizontalAlignment, verticalAlignment, shadow, textScale);
        }
    }

    public void renderScrollingText(class_4587 poseStack, StyledText styledText, float x, float y, float renderWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow shadow) {
        this.renderScrollingText(poseStack, styledText, x, y, renderWidth, customColor, horizontalAlignment, verticalAlignment, shadow, 1.0f);
    }

    public void renderScrollingAlignedTextInBox(class_4587 poseStack, StyledText text, float x1, float x2, float y1, float y2, float renderWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow, float textScale) {
        float renderX = switch (horizontalAlignment) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> x1;
            case HorizontalAlignment.CENTER -> (x1 + x2) / 2.0f;
            case HorizontalAlignment.RIGHT -> x2;
        };
        float renderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> y1;
            case VerticalAlignment.MIDDLE -> (y1 + y2) / 2.0f;
            case VerticalAlignment.BOTTOM -> y2;
        };
        this.renderScrollingText(poseStack, text, renderX, renderY, renderWidth, customColor, horizontalAlignment, verticalAlignment, textShadow, textScale);
    }

    public void renderScrollingAlignedTextInBox(class_4587 poseStack, StyledText text, float x1, float x2, float y1, float y2, float renderWidth, CustomColor customColor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, TextShadow textShadow) {
        this.renderScrollingAlignedTextInBox(poseStack, text, x1, x2, y1, y2, renderWidth, customColor, horizontalAlignment, verticalAlignment, textShadow, 1.0f);
    }

    public void renderText(class_4587 poseStack, float x, float y, TextRenderTask line, class_327.class_6415 displayMode) {
        this.renderText(poseStack, line.getText(), x, y, line.getSetting().maxWidth(), line.getSetting().customColor(), line.getSetting().horizontalAlignment(), line.getSetting().verticalAlignment(), line.getSetting().shadow(), displayMode);
    }

    public void renderText(class_4587 poseStack, float x, float y, TextRenderTask line) {
        this.renderText(poseStack, x, y, line, class_327.class_6415.field_33994);
    }

    public void renderTexts(class_4587 poseStack, float x, float y, List<TextRenderTask> lines) {
        float currentY = y;
        for (TextRenderTask line : lines) {
            this.renderText(poseStack, x, currentY, line);
            currentY += this.calculateRenderHeight(line.getText(), line.getSetting().maxWidth());
        }
    }

    public void renderTextsWithAlignment(class_4587 poseStack, float x, float y, List<TextRenderTask> toRender, float width, float height, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        float renderX = switch (horizontalAlignment) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.LEFT -> x;
            case HorizontalAlignment.CENTER -> x + width / 2.0f;
            case HorizontalAlignment.RIGHT -> x + width;
        };
        float renderY = switch (verticalAlignment) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> y;
            case VerticalAlignment.MIDDLE -> y + (height - this.calculateRenderHeight(toRender)) / 2.0f;
            case VerticalAlignment.BOTTOM -> y + (height - this.calculateRenderHeight(toRender));
        };
        this.renderTexts(poseStack, renderX, renderY, toRender);
    }

    public void renderTextWithAlignment(class_4587 poseStack, float renderX, float renderY, TextRenderTask toRender, float width, float height, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this.renderTextsWithAlignment(poseStack, renderX, renderY, List.of(toRender), width, height, horizontalAlignment, verticalAlignment);
    }

    public float calculateRenderHeight(List<TextRenderTask> toRender) {
        if (toRender.isEmpty()) {
            return 0.0f;
        }
        float height = 0.0f;
        int totalLineCount = 0;
        for (TextRenderTask textRenderTask : toRender) {
            if (textRenderTask.getSetting().maxWidth() == 0.0f) {
                Objects.requireNonNull(this.font);
                height += 9.0f;
            } else {
                height += this.calculateRenderHeight(textRenderTask.getText(), textRenderTask.getSetting().maxWidth());
            }
            ++totalLineCount;
        }
        Objects.requireNonNull(this.font);
        return height += (float)((totalLineCount - 1) * (10 - 9));
    }

    public float calculateRenderHeight(List<StyledText> lines, float maxWidth) {
        return (float)lines.stream().mapToDouble(line -> this.calculateRenderHeight((StyledText)line, maxWidth)).sum();
    }

    public float calculateRenderHeight(String line, float maxWidth) {
        return this.calculateRenderHeight(StyledText.fromString(line), maxWidth);
    }

    public float calculateRenderHeight(StyledText line, float maxWidth) {
        return this.font.method_44378((class_5348)(line.isEmpty() ? class_2561.method_43470((String)" ") : line.getComponent()), maxWidth == 0.0f ? Integer.MAX_VALUE : (int)maxWidth);
    }
}

