/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.render.type;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.joml.Math;

public final class AnimationPercentage {
    private final Supplier<Boolean> openingConditions;
    private Duration openingDuration;
    private Instant lastTime = Instant.EPOCH;
    private double openingProgress;

    public AnimationPercentage(Supplier<Boolean> openingConditions, Duration openingDuration) {
        this.openingConditions = openingConditions;
        this.openingDuration = openingDuration;
    }

    public double getAnimation() {
        if (this.openingDuration.isZero() || this.openingDuration.isNegative()) {
            return 1.0;
        }
        if (this.openingProgress == 0.0) {
            this.lastTime = Instant.now().minus(1L, ChronoUnit.MILLIS);
        }
        if (this.openingConditions.get().booleanValue()) {
            this.addOpeningProgress((double)Duration.between(this.lastTime, Instant.now()).toMillis() / (double)this.openingDuration.toMillis());
        } else if (this.openingProgress > 0.0) {
            this.addOpeningProgress((double)(-Duration.between(this.lastTime, Instant.now()).toMillis()) / (double)this.openingDuration.toMillis());
        }
        this.lastTime = Instant.now();
        return AnimationPercentage.applyTransformation(this.openingProgress);
    }

    public double getAnimationWithoutUpdate() {
        return this.openingProgress;
    }

    private void addOpeningProgress(double openingProgress) {
        this.setOpeningProgress(this.openingProgress + openingProgress);
    }

    private void setOpeningProgress(double openingProgress) {
        this.openingProgress = Math.clamp((double)0.0, (double)1.0, (double)openingProgress);
    }

    private static double applyTransformation(double openingProgress) {
        return java.lang.Math.sin((float)(openingProgress / 2.0 * java.lang.Math.PI));
    }

    public void setOpeningDuration(Duration openingDuration) {
        this.openingDuration = openingDuration;
    }

    public boolean finishedClosingAnimation() {
        return this.openingProgress == 0.0;
    }
}

