/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.type;

import java.util.Arrays;

public class ArrayReader<T> {
    private final T[] array;
    private int index;

    public ArrayReader(T[] array) {
        this.array = Arrays.copyOf(array, array.length);
        this.index = 0;
    }

    public T peek() {
        if (this.index >= this.array.length) {
            throw new ArrayIndexOutOfBoundsException("Tried to read past the end of the array");
        }
        return this.array[this.index];
    }

    public T read() {
        if (this.index >= this.array.length) {
            throw new ArrayIndexOutOfBoundsException("Tried to read past the end of the array");
        }
        return this.array[this.index++];
    }

    public T[] read(int length) {
        if (this.index + length > this.array.length) {
            throw new ArrayIndexOutOfBoundsException("Tried to read past the end of the array");
        }
        T[] result = Arrays.copyOfRange(this.array, this.index, this.index + length);
        this.index += length;
        return result;
    }

    public T[] readRemaining() {
        return this.read(this.array.length - this.index);
    }

    public boolean hasRemaining() {
        return this.index < this.array.length;
    }
}

