/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.type;

import com.wynntils.utils.type.BoundingShape;

public record BoundingBox(float x1, float z1, float x2, float z2) implements BoundingShape
{
    public static final BoundingBox EMPTY = new BoundingBox(0.0f, 0.0f, 0.0f, 0.0f);

    public BoundingBox(float x1, float z1, float x2, float z2) {
        this.x1 = x1;
        this.z1 = z1;
        this.x2 = x2;
        this.z2 = z2;
        assert (x1 <= x2 && z1 <= z2);
    }

    public static BoundingBox centered(float centerX, float centerZ, float widthX, float widthZ) {
        return new BoundingBox(centerX - widthX / 2.0f, centerZ - widthZ / 2.0f, centerX + widthX / 2.0f, centerZ + widthZ / 2.0f);
    }

    @Override
    public boolean contains(float x, float z) {
        return this.x1 <= x && x <= this.x2 && this.z1 <= z && z <= this.z2;
    }
}

