/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.type;

import com.wynntils.core.WynntilsMod;

public final class ErrorOr<T> {
    private final T value;
    private final String error;

    private ErrorOr(T value, String error) {
        this.value = value;
        this.error = error;
    }

    public static <T> ErrorOr<T> of(T value) {
        return new ErrorOr<T>(value, null);
    }

    public static <T> ErrorOr<T> error(String error) {
        return new ErrorOr<Object>(null, error);
    }

    public T getValue() {
        if (this.hasError()) {
            throw new IllegalStateException("Error present.");
        }
        return this.value;
    }

    public String getError() {
        if (!this.hasError()) {
            throw new IllegalStateException("No error present.");
        }
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public ErrorOr<T> logged() {
        if (!this.hasError()) {
            throw new IllegalStateException("Tried to log when no error is present.");
        }
        WynntilsMod.error(this.error);
        return this;
    }

    public String toString() {
        return "ErrorOr{value=" + String.valueOf(this.value) + ", error='" + this.error + "'}";
    }
}

