/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.type;

import java.util.Objects;

public final class UnsignedByte {
    private final short value;

    public UnsignedByte(byte value) {
        this.value = (short)(value & 0xFF);
    }

    public static UnsignedByte of(byte value) {
        return new UnsignedByte(value);
    }

    public static UnsignedByte[] of(byte[] values) {
        UnsignedByte[] result = new UnsignedByte[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = UnsignedByte.of(values[i]);
        }
        return result;
    }

    public static byte[] toPrimitive(UnsignedByte[] values) {
        byte[] result = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = (byte)values[i].value();
        }
        return result;
    }

    public static short[] asShort(UnsignedByte[] values) {
        short[] result = new short[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].value();
        }
        return result;
    }

    public short value() {
        return this.value;
    }

    public byte toByte() {
        return (byte)this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedByte that = (UnsignedByte)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "UnsignedByte{" + this.value + "}";
    }
}

