/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.services.map.type.CustomPoiProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class MapCommand
extends Command {
    private static final SuggestionProvider<class_2168> POI_PROVIDER_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9253((String[])((String[])Services.Poi.getCustomPoiProviders().stream().map(CustomPoiProvider::getName).toArray(String[]::new)), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "map";
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"map").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"poiProvider").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).executes(this::addPoiProvider))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(POI_PROVIDER_SUGGESTION_PROVIDER).executes(this::removePoiProvider)))).then(class_2170.method_9247((String)"list").executes(this::listPoiProviders))).then(class_2170.method_9247((String)"reload").executes(this::reloadPoiProviders))).then(class_2170.method_9247((String)"toggle").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(POI_PROVIDER_SUGGESTION_PROVIDER).executes(this::togglePoiProvider))));
    }

    private int reloadPoiProviders(CommandContext<class_2168> context) {
        Services.Poi.loadCustomPoiProviders();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully reloaded POI providers.").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int addPoiProvider(CommandContext<class_2168> context) {
        String name = (String)context.getArgument("name", String.class);
        String url = (String)context.getArgument("url", String.class);
        try {
            Services.Poi.addCustomPoiProvider(new CustomPoiProvider(name, new URI(url)));
        }
        catch (URISyntaxException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"The provided URL is invalid.").method_27692(class_124.field_1061));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully added POI provider.").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int removePoiProvider(CommandContext<class_2168> context) {
        String name = (String)context.getArgument("name", String.class);
        if (!Services.Poi.removeCustomPoiProvider(name)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"The provided name does not match any POI provider.").method_27692(class_124.field_1061));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully removed POI provider.").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int listPoiProviders(CommandContext<class_2168> context) {
        class_5250 message = class_2561.method_43470((String)"POI providers: ").method_27692(class_124.field_1054);
        for (CustomPoiProvider poiProvider : Services.Poi.getCustomPoiProviders()) {
            message.method_10852((class_2561)class_2561.method_43470((String)"\n"));
            message.method_10852((class_2561)class_2561.method_43470((String)poiProvider.getName()).method_27692(class_124.field_1065));
            message.method_10852((class_2561)class_2561.method_43470((String)(poiProvider.isEnabled() ? " (enabled)" : " (disabled)")).method_27692(poiProvider.isEnabled() ? class_124.field_1060 : class_124.field_1061));
            message.method_10852((class_2561)class_2561.method_43473());
            message.method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080));
            message.method_10852((class_2561)class_2561.method_43470((String)poiProvider.getUrl().toString()).method_27692(class_124.field_1080));
            message.method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080));
        }
        ((class_2168)context.getSource()).method_9226(() -> message, false);
        return 1;
    }

    private int togglePoiProvider(CommandContext<class_2168> context) {
        String name = (String)context.getArgument("name", String.class);
        Optional<CustomPoiProvider> poiProvider = Services.Poi.getCustomPoiProviders().stream().filter(p -> p.getName().equals(name)).findFirst();
        if (poiProvider.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"The provided name does not match any POI provider.").method_27692(class_124.field_1061));
            return 0;
        }
        poiProvider.get().setEnabled(!poiProvider.get().isEnabled());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully toggled POI provider ").method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to ")).method_10852((class_2561)class_2561.method_43470((String)(((CustomPoiProvider)poiProvider.get()).isEnabled() ? "enabled" : "disabled")).method_27692(class_124.field_1073)), false);
        return 1;
    }
}

