/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.models.worlds.profile.ServerProfile;
import com.wynntils.utils.StringUtils;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class ServersCommand
extends Command {
    private static final int UPDATE_TIME_OUT_MS = 3000;
    private static final SuggestionProvider<class_2168> SERVERS_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(Models.ServerList.getServers(), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "servers";
    }

    @Override
    protected List<String> getAliases() {
        return List.of("s", "srv");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        LiteralCommandNode listBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").then(class_2170.method_9247((String)"up").executes(this::serverUptimeList))).executes(this::serverList)).build();
        LiteralCommandNode infoBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"server", (ArgumentType)StringArgumentType.word()).suggests(SERVERS_SUGGESTION_PROVIDER).executes(this::serverInfo))).executes(this::serverInfo)).build();
        LiteralArgumentBuilder infoAliasBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"i").then(class_2170.method_9244((String)"server", (ArgumentType)StringArgumentType.word()).suggests(SERVERS_SUGGESTION_PROVIDER).executes(this::serverInfo))).executes(this::serverInfo);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then((CommandNode)listBuilder)).then((CommandNode)infoBuilder)).then(class_2170.method_9247((String)"l").executes(this::serverList))).then(class_2170.method_9247((String)"ul").executes(this::serverUptimeList))).then(class_2170.method_9247((String)"up").executes(this::serverUptimeList))).then((ArgumentBuilder)infoAliasBuilder)).executes(this::syntaxError);
    }

    private int serverInfo(CommandContext<class_2168> context) {
        Object server;
        try {
            server = (String)context.getArgument("server", String.class);
        }
        catch (Exception e) {
            server = Models.WorldState.getCurrentWorldName();
        }
        try {
            int serverNum = Integer.parseInt((String)server);
            server = Models.WorldState.getCurrentServerRegion().name() + serverNum;
        }
        catch (Exception ignored) {
            server = ((String)server).toUpperCase(Locale.ROOT);
        }
        ServerProfile serverProfile = Models.ServerList.getServer((String)server);
        if (serverProfile == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)((String)server + " not found.")).method_27692(class_124.field_1061));
            return 1;
        }
        Set<String> players = serverProfile.getPlayers();
        class_5250 message = class_2561.method_43473().method_10852((class_2561)this.getServerComponent((String)server).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)":\n").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"Uptime: ").method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)(serverProfile.getUptime() + "\n")).method_27692(class_124.field_1075))).method_10852((class_2561)class_2561.method_43470((String)"Online players on ").method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)server).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)(players.size() + "\n")).method_27692(class_124.field_1075))));
        if (players.isEmpty()) {
            message.method_10852((class_2561)class_2561.method_43470((String)"No players!").method_27692(class_124.field_1075));
        } else {
            message.method_10852((class_2561)class_2561.method_43470((String)String.join((CharSequence)", ", players)).method_27692(class_124.field_1075));
        }
        ((class_2168)context.getSource()).method_9226(() -> message, false);
        return 1;
    }

    private int serverList(CommandContext<class_2168> context) {
        class_5250 message = class_2561.method_43470((String)"Server list:").method_27692(class_124.field_1062);
        for (String serverType : Models.ServerList.getWynnServerTypes()) {
            List<String> currentTypeServers = Models.ServerList.getServersSortedOnNameOfType(serverType);
            if (currentTypeServers.isEmpty()) continue;
            message.method_27693("\n");
            message.method_10852((class_2561)class_2561.method_43470((String)(StringUtils.capitalizeFirst(serverType) + " (" + currentTypeServers.size() + "):\n")).method_27692(class_124.field_1065));
            String lastServer = currentTypeServers.getLast();
            for (String server : currentTypeServers) {
                message.method_10852((class_2561)this.getServerComponent(server).method_27692(class_124.field_1075));
                if (server.equals(lastServer)) continue;
                message.method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1062));
            }
        }
        ((class_2168)context.getSource()).method_9226(() -> message, false);
        return 1;
    }

    private int serverUptimeList(CommandContext<class_2168> context) {
        List<String> sortedServers = Models.ServerList.getServersSortedOnUptime();
        class_5250 message = class_2561.method_43470((String)"Server list:").method_27692(class_124.field_1065);
        for (String server : sortedServers) {
            message.method_27693("\n");
            message.method_10852((class_2561)this.getServerComponent(server).method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)(": " + Models.ServerList.getServer(server).getUptime())).method_27692(class_124.field_1075)));
        }
        ((class_2168)context.getSource()).method_9226(() -> message, false);
        return 1;
    }

    private int syntaxError(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Missing argument").method_27692(class_124.field_1061));
        return 0;
    }

    private class_5250 getServerComponent(String server) {
        return class_2561.method_43470((String)server).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to switch to ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)server).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"\n(Requires ").method_27692(class_124.field_1064).method_10852((class_2561)class_2561.method_43470((String)"HERO").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" rank)").method_27692(class_124.field_1064)))))).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/switch " + server)));
    }
}

