/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.UrlId;
import com.wynntils.screens.downloads.DownloadScreen;
import com.wynntils.screens.maps.GuildMapScreen;
import com.wynntils.screens.maps.MainMapScreen;
import com.wynntils.screens.playerviewer.GearSharingSettingsScreen;
import com.wynntils.screens.wynntilsmenu.WynntilsMenuScreen;
import com.wynntils.services.athena.type.UpdateResult;
import com.wynntils.utils.FileUtils;
import com.wynntils.utils.mc.McUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class WynntilsCommand
extends Command {
    private static final Pattern STATUS_HEADING = Pattern.compile("<h1 class='status-page__title'>(.*)</h1>");

    public void registerWithCommands(Consumer<LiteralArgumentBuilder<class_2168>> consumer, class_7157 context, List<Command> commands) {
        List<LiteralArgumentBuilder<class_2168>> commandBuilders = this.getCommandBuilders(context);
        for (LiteralArgumentBuilder<class_2168> builder : commandBuilders) {
            for (Command commandInstance : commands) {
                if (commandInstance == this) continue;
                commandInstance.getCommandBuilders(context).forEach(arg_0 -> builder.then(arg_0));
            }
            consumer.accept(builder);
        }
    }

    @Override
    public String getCommandName() {
        return "wynntils";
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clearcaches").then(class_2170.method_9247((String)"run").executes(this::doClearCaches))).executes(this::clearCaches))).then(class_2170.method_9247((String)"debug").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"profile").then(class_2170.method_9247((String)"reset").executes(this::profileReset))).then(class_2170.method_9247((String)"showAnnotations").executes(this::profileShowAnnotations))).then(class_2170.method_9247((String)"showOverlays").executes(this::profileShowOverlays))))).then(class_2170.method_9247((String)"discord").executes(this::discordLink))).then(class_2170.method_9247((String)"donate").executes(this::donateLink))).then(class_2170.method_9247((String)"downloads").executes(this::downloads))).then(class_2170.method_9247((String)"gearsharing").executes(this::openGearSharingSettings))).then(class_2170.method_9247((String)"guildmap").executes(this::openGuildMap))).then(class_2170.method_9247((String)"help").executes(this::help))).then(class_2170.method_9247((String)"map").executes(this::openMap))).then(class_2170.method_9247((String)"menu").executes(this::openMenu))).then(class_2170.method_9247((String)"reauth").executes(this::reauth))).then(class_2170.method_9247((String)"reloadcaches").executes(this::reloadCaches))).then(class_2170.method_9247((String)"rescan").executes(this::rescan))).then(class_2170.method_9247((String)"status").executes(this::status))).then(class_2170.method_9247((String)"token").executes(this::token))).then(class_2170.method_9247((String)"update").executes(this::update))).then(class_2170.method_9247((String)"version").executes(this::version))).executes(this::help);
    }

    private int profileReset(CommandContext<class_2168> context) {
        Handlers.Item.resetProfiling();
        Managers.Overlay.resetProfiling();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.debug.profile.cleared").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int profileShowAnnotations(CommandContext<class_2168> context) {
        Map<Class<?>, Integer> profilingTimes = Handlers.Item.getProfilingTimes();
        Map<Class<?>, Integer> profilingCounts = Handlers.Item.getProfilingCounts();
        this.showProfilingData(context, profilingTimes, profilingCounts);
        return 1;
    }

    private int profileShowOverlays(CommandContext<class_2168> context) {
        Map<Class<?>, Integer> profilingTimes = Managers.Overlay.getProfilingTimes();
        Map<Class<?>, Integer> profilingCounts = Managers.Overlay.getProfilingCounts();
        this.showProfilingData(context, profilingTimes, profilingCounts);
        return 1;
    }

    private void showProfilingData(CommandContext<class_2168> context, Map<Class<?>, Integer> profilingTimes, Map<Class<?>, Integer> profilingCounts) {
        StringBuilder resList = new StringBuilder();
        profilingTimes.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).forEach(entry -> {
            int time = (Integer)entry.getValue();
            int count = (Integer)profilingCounts.get(entry.getKey());
            double average = (double)time / (double)count;
            resList.append("%7d ms, %7d c, avg: %7.2f ms/c  %s\n".formatted(time, count, average, ((Class)entry.getKey()).getSimpleName()));
        });
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)resList.toString()).method_27692(class_124.field_1075), false);
        int totalCount = profilingCounts.values().stream().reduce(0, Integer::sum);
        int totalTime = profilingTimes.values().stream().reduce(0, Integer::sum);
        double average = (double)totalTime / (double)totalCount;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.wynntils.debug.profile.total", (Object[])new Object[]{totalTime, totalCount}).method_27692(class_124.field_1075), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.wynntils.debug.profile.avg", (Object[])new Object[]{average}).method_27692(class_124.field_1075), false);
    }

    private int reauth(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.reauth.tryReauth").method_27692(class_124.field_1060), false);
        Services.Hades.tryDisconnect();
        Services.WynntilsAccount.reloadData();
        Models.Player.reset();
        return 1;
    }

    private int openGearSharingSettings(CommandContext<class_2168> commandSourceStackCommandContext) {
        Managers.TickScheduler.scheduleNextTick(() -> McUtils.mc().method_1507((class_437)GearSharingSettingsScreen.create(null)));
        return 1;
    }

    private int clearCaches(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.clearCaches.warn").method_27692(class_124.field_1079), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.clearCaches.clickHere").method_27692(class_124.field_1078).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/wynntils clearcaches run"))), false);
        return 1;
    }

    private int doClearCaches(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.clearCaches.deleting").method_27692(class_124.field_1054), false);
        Managers.TickScheduler.scheduleLater(() -> {
            FileUtils.deleteFolder(Managers.Net.getCacheDir());
            FileUtils.deleteFolder(Services.Update.getUpdatesFolder());
            System.exit(0);
        }, 100);
        return 1;
    }

    private int reloadCaches(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.reloadCaches.reloading").method_27692(class_124.field_1054), false);
        Managers.Url.loadUrls();
        return 1;
    }

    private int downloads(CommandContext<class_2168> context) {
        Managers.TickScheduler.scheduleNextTick(() -> McUtils.mc().method_1507(DownloadScreen.create(null, null)));
        return 1;
    }

    private int version(CommandContext<class_2168> context) {
        class_5250 buildText = WynntilsMod.getVersion().isEmpty() ? class_2561.method_43470((String)"Unknown Version") : (WynntilsMod.isDevelopmentBuild() ? class_2561.method_43470((String)"Development Build") : class_2561.method_43470((String)("Version " + WynntilsMod.getVersion())));
        buildText.method_10862(buildText.method_10866().method_10977(class_124.field_1054));
        ((class_2168)context.getSource()).method_9226(() -> buildText, false);
        return 1;
    }

    private int status(CommandContext<class_2168> context) {
        class_5250 component = class_2561.method_43470((String)"Reading status of Wynntils services from ").method_27692(class_124.field_1068);
        class_5250 url = class_2561.method_43470((String)Managers.Url.getUrl(UrlId.LINK_WYNNTILS_STATUS)).method_27696(class_2583.field_24360.method_10977(class_124.field_1076).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, Managers.Url.getUrl(UrlId.LINK_WYNNTILS_STATUS))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click here to open in your browser."))));
        ((class_2168)context.getSource()).method_9226(() -> component.method_10852((class_2561)url), false);
        ApiResponse result = Managers.Net.callApi(UrlId.LINK_WYNNTILS_STATUS);
        result.handleInputStream(is -> {
            try (InputStreamReader isReader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
                 BufferedReader reader = new BufferedReader(isReader);){
                while (true) {
                    String line;
                    if ((line = reader.readLine()) != null) {
                        Matcher m = STATUS_HEADING.matcher(line);
                        if (!m.matches()) continue;
                        String status = m.group(1);
                        McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)"Wynntils status: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)status).method_27692(class_124.field_1075)));
                        return;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                WynntilsMod.warn("Failed to read status page", e);
            }
            McUtils.sendErrorToClient("Failed to read status page");
        }, onError -> {
            WynntilsMod.warn("Failed to read status page", onError);
            McUtils.sendErrorToClient("Failed to read status page");
        });
        return 1;
    }

    private int donateLink(CommandContext<class_2168> context) {
        class_5250 c = class_2561.method_43470((String)"You can donate to Wynntils at: ").method_27692(class_124.field_1075);
        class_5250 url = class_2561.method_43470((String)Managers.Url.getUrl(UrlId.LINK_WYNNTILS_PATREON)).method_27696(class_2583.field_24360.method_10977(class_124.field_1076).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, Managers.Url.getUrl(UrlId.LINK_WYNNTILS_PATREON))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click here to open in your browser."))));
        ((class_2168)context.getSource()).method_9226(() -> c.method_10852((class_2561)url), false);
        return 1;
    }

    private int discordLink(CommandContext<class_2168> context) {
        class_5250 msg = class_2561.method_43470((String)"You're welcome to join our Discord server at:\n").method_27692(class_124.field_1065);
        String discordInvite = Managers.Url.getUrl(UrlId.LINK_WYNNTILS_DISCORD_INVITE);
        class_5250 link = class_2561.method_43470((String)discordInvite).method_27696(class_2583.field_24360.method_10977(class_124.field_1062));
        link.method_10862(link.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11749, discordInvite)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click here to join our Discord server."))));
        ((class_2168)context.getSource()).method_9226(() -> msg.method_10852((class_2561)link), false);
        return 1;
    }

    private int token(CommandContext<class_2168> context) {
        if (!Services.WynntilsAccount.isLoggedIn()) {
            class_5250 failed = class_2561.method_43470((String)"Either setting up your Wynntils account or accessing the token failed. To try to set up the Wynntils account again, run ").method_27692(class_124.field_1060);
            failed.method_10852((class_2561)class_2561.method_43470((String)"/wynntils reauth").method_27696(class_2583.field_24360.method_10977(class_124.field_1075).method_10958(new class_2558(class_2558.class_2559.field_11750, "/wynntils reauth"))));
            ((class_2168)context.getSource()).method_9213((class_2561)failed);
            return 1;
        }
        String token = Services.WynntilsAccount.getToken();
        class_5250 text = class_2561.method_43470((String)"Wynntils Token ").method_27692(class_124.field_1075);
        class_5250 response = class_2561.method_43470((String)token).method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click me to register an account."))).method_10958(new class_2558(class_2558.class_2559.field_11749, Managers.Url.buildUrl(UrlId.LINK_WYNNTILS_REGISTER_ACCOUNT, Map.of("token", token)))).method_10977(class_124.field_1062).method_30938(Boolean.valueOf(true)));
        text.method_10852((class_2561)response);
        ((class_2168)context.getSource()).method_9226(() -> text, false);
        return 1;
    }

    private int update(CommandContext<class_2168> context) {
        if (WynntilsMod.isDevelopmentEnvironment()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"feature.wynntils.updates.error.development").method_27692(class_124.field_1079));
            WynntilsMod.error("Development environment detected, cannot update!");
            return 0;
        }
        CompletableFuture.runAsync(() -> {
            WynntilsMod.info("Attempting to fetch Wynntils update.");
            CompletableFuture<UpdateResult> completableFuture = Services.Update.tryUpdate();
            completableFuture.whenComplete((result, throwable) -> McUtils.sendMessageToClient((class_2561)result.getMessage()));
        });
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"feature.wynntils.updates.checking").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int openGuildMap(CommandContext<class_2168> context) {
        return this.openScreen(GuildMapScreen.create());
    }

    private int openMap(CommandContext<class_2168> context) {
        return this.openScreen(MainMapScreen.create());
    }

    private int openMenu(CommandContext<class_2168> context) {
        return this.openScreen(WynntilsMenuScreen.create());
    }

    private int openScreen(class_437 screenToOpen) {
        Managers.TickScheduler.scheduleLater(() -> McUtils.mc().method_1507(screenToOpen), 2);
        return 1;
    }

    private int rescan(CommandContext<class_2168> context) {
        Models.Character.scanCharacterInfo();
        Models.Account.scanRankInfo(true);
        return 1;
    }

    private int help(CommandContext<class_2168> context) {
        class_5250 text = class_2561.method_43470((String)"Available Wynntils commands: \n").method_27696(class_2583.field_24360.method_10977(class_124.field_1065));
        WynntilsCommand.describeWynntilsSubcommand(text, "clearcaches", "Clears all Wynntils caches and closes the game");
        WynntilsCommand.describeWynntilsSubcommand(text, "debug", "Debug command for developers.");
        WynntilsCommand.describeWynntilsSubcommand(text, "discord", "Provide an invite link to our Discord server");
        WynntilsCommand.describeWynntilsSubcommand(text, "donate", "Provides a link to our Patreon");
        WynntilsCommand.describeWynntilsSubcommand(text, "help", "List of all available commands for Wynntils");
        WynntilsCommand.describeWynntilsSubcommand(text, "menu", "Opens Wynntils Menu");
        WynntilsCommand.describeWynntilsSubcommand(text, "reauth", "Re-authorize Wynntils online services (Athena and Hades)");
        WynntilsCommand.describeWynntilsSubcommand(text, "reloadcaches", "Clear and re-download caches of online data");
        WynntilsCommand.describeWynntilsSubcommand(text, "status", "Show Wynntils server status");
        WynntilsCommand.describeWynntilsSubcommand(text, "token", "Provide a link for creating a Wynntils account");
        WynntilsCommand.describeWynntilsSubcommand(text, "update", "Update Wynntils to the latest version");
        WynntilsCommand.describeWynntilsSubcommand(text, "version", "Shows the version of Wynntils currently installed");
        List<Command> otherCommands = Managers.Command.getCommandInstanceSet().stream().filter(c -> !(c instanceof WynntilsCommand)).toList();
        for (Command command : otherCommands) {
            WynntilsCommand.describeCommand(text, command.getCommandName(), command.getDescription());
        }
        ((class_2168)context.getSource()).method_9226(() -> text, false);
        return 1;
    }

    private static void describeWynntilsSubcommand(class_5250 text, String subcommand, String description) {
        WynntilsCommand.describeCommand(text, "wynntils " + subcommand, description);
    }

    private static void describeCommand(class_5250 text, String command, String description) {
        class_5250 clickComponent = class_2561.method_43473();
        clickComponent.method_10862(clickComponent.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11745, "/" + command)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click here to run this command"))));
        clickComponent.method_10852((class_2561)class_2561.method_43470((String)("/" + command)).method_27692(class_124.field_1060));
        clickComponent.method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1063));
        clickComponent.method_10852((class_2561)class_2561.method_43470((String)description).method_27692(class_124.field_1080));
        text.method_27693("\n");
        text.method_10852((class_2561)clickComponent);
    }
}

