/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.functions.arguments;

import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.NamedValue;
import com.wynntils.utils.type.RangedValue;
import com.wynntils.utils.type.Time;
import java.util.List;

public class Argument<T> {
    protected static final List<Class<?>> SUPPORTED_ARGUMENT_TYPES = List.of(String.class, Boolean.class, Integer.class, Long.class, Double.class, Number.class, CustomColor.class, CappedValue.class, RangedValue.class, NamedValue.class, Location.class, Time.class);
    private final String name;
    private final Class<T> type;
    private final T defaultValue;
    private T value;

    public Argument(String name, Class<T> type, T defaultValue) {
        this(name, type, defaultValue, true);
    }

    protected Argument(String name, Class<T> type, T defaultValue, boolean check) {
        if (check && !SUPPORTED_ARGUMENT_TYPES.contains(type)) {
            throw new IllegalArgumentException("Unsupported argument type: " + String.valueOf(type));
        }
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    protected void setValue(Object value) {
        if (!this.type.isInstance(value)) {
            throw new IllegalArgumentException("Value is not of type " + this.type.getSimpleName() + ".");
        }
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getValue() {
        return this.value == null ? this.defaultValue : this.value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    protected <U> U getValueChecked(Class<U> assumedType) {
        if (!assumedType.equals(this.type)) {
            throw new IllegalStateException("Argument is a " + this.type.getSimpleName() + ", not a " + assumedType.getSimpleName() + ".");
        }
        return assumedType.cast(this.getValue());
    }

    public Boolean getBooleanValue() {
        return this.getValueChecked(Boolean.class);
    }

    public Integer getIntegerValue() {
        if (this.type == Number.class) {
            return this.getValueChecked(Number.class).intValue();
        }
        return this.getValueChecked(Integer.class);
    }

    public Long getLongValue() {
        if (this.type == Number.class) {
            return this.getValueChecked(Number.class).longValue();
        }
        return this.getValueChecked(Long.class);
    }

    public Double getDoubleValue() {
        if (this.type == Number.class) {
            return this.getValueChecked(Number.class).doubleValue();
        }
        return this.getValueChecked(Double.class);
    }

    public CappedValue getCappedValue() {
        return this.getValueChecked(CappedValue.class);
    }

    public CustomColor getColorValue() {
        return this.getValueChecked(CustomColor.class);
    }

    public RangedValue getRangedValue() {
        return this.getValueChecked(RangedValue.class);
    }

    public NamedValue getNamedValue() {
        return this.getValueChecked(NamedValue.class);
    }

    public Location getLocation() {
        return this.getValueChecked(Location.class);
    }

    public Time getTime() {
        return (Time)this.getValue();
    }

    public String getStringValue() {
        return this.getValueChecked(String.class);
    }

    protected <U> List<U> getList(Class<U> assumedType) {
        throw new IllegalStateException("Argument is not a List.");
    }

    public List<Boolean> getBooleanList() {
        return this.getList(Boolean.class);
    }

    public List<Number> getNumberList() {
        return this.getList(Number.class);
    }

    public List<String> getStringList() {
        return this.getList(String.class);
    }
}

