/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.net;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.net.NetManager;
import com.wynntils.core.net.NetResult;
import com.wynntils.core.net.event.NetResultProcessedEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;

public class Download
extends NetResult {
    private final File localFile;
    private CompletableFuture<HttpResponse<Path>> httpResponse = null;

    public Download(String desc, File localFile, NetResultProcessedEvent processedEvent) {
        super("DL:" + desc, null, processedEvent);
        this.localFile = localFile;
    }

    public Download(String desc, File localFile, HttpRequest request, NetResultProcessedEvent processedEvent) {
        super("DL:" + desc, request, processedEvent);
        this.localFile = localFile;
    }

    public long getResponseTimestamp() {
        if (this.httpResponse == null) {
            return System.currentTimeMillis();
        }
        try {
            HttpHeaders headers = this.httpResponse.get().headers();
            OptionalLong a = headers.firstValueAsLong("timestamp");
            if (a.isEmpty()) {
                return System.currentTimeMillis();
            }
            return a.getAsLong();
        }
        catch (InterruptedException | ExecutionException e) {
            return System.currentTimeMillis();
        }
    }

    @Override
    protected void onHandlingFailed() {
        WynntilsMod.warn("Deleting cached file due to handling error: " + String.valueOf(this.localFile));
        FileUtils.deleteQuietly((File)this.localFile);
    }

    @Override
    protected CompletableFuture<InputStream> getInputStreamFuture() {
        if (this.request == null) {
            return CompletableFuture.supplyAsync(this::getFileInputStreamFromCache);
        }
        this.prepareForDownload();
        return this.getDownloadInputStreamFuture().thenApply(response -> this.getFileInputStreamFromCache());
    }

    private CompletableFuture<HttpResponse<Path>> getDownloadInputStreamFuture() {
        CompletableFuture<HttpResponse<Path>> future = NetManager.HTTP_CLIENT.sendAsync(this.request, HttpResponse.BodyHandlers.ofFile(this.localFile.toPath()));
        this.httpResponse = future;
        return future;
    }

    private InputStream getFileInputStreamFromCache() {
        try {
            return new FileInputStream(this.localFile);
        }
        catch (FileNotFoundException e) {
            WynntilsMod.error("File went missing from cache", e);
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private void prepareForDownload() {
        FileUtils.deleteQuietly((File)this.localFile);
        try {
            FileUtils.forceMkdirParent((File)this.localFile);
        }
        catch (IOException e) {
            WynntilsMod.error("Failed to create directories needed for " + String.valueOf(this.localFile), e);
        }
    }
}

