/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.net;

import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.MalformedJsonException;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;
import com.wynntils.core.net.Download;
import com.wynntils.core.net.NetManager;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.net.event.UrlProcessingFinishedEvent;
import com.wynntils.core.properties.Property;
import com.wynntils.utils.FileUtils;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.type.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class UrlManager
extends Manager {
    private final Property<URI> urlListOverride = this.createProperty(URI.class, "override.link");
    private final Property<Boolean> ignoreCache = this.createProperty(Boolean.class, "ignore.cache", false);
    private final Property<Boolean> debugLogs = this.createProperty(Boolean.class, "log.debug", false);
    private final Property<UrlMapperType> urlMapperForceType = this.createProperty(UrlMapperType.class, "force.type");
    private final Map<UrlMapperType, UrlMapper> urlMappersByType = new ConcurrentHashMap<UrlMapperType, UrlMapper>();
    private UrlMapper urlMapper = UrlMapper.EMPTY;

    public UrlManager(NetManager netManager) {
        super(List.of(netManager));
        if (this.urlListOverride.get() == null) {
            WynntilsMod.info("Loading urls.json in the normal mode. Url cache is " + (this.ignoreCache.get() != false ? "ignored" : "used") + ".");
        } else {
            WynntilsMod.info("Loading urls.json from " + String.valueOf(this.urlListOverride.get()) + ". Url cache is " + (this.ignoreCache.get() != false ? "ignored" : "used") + ".");
        }
    }

    public UrlInfo getUrlInfo(UrlId urlId) {
        return this.urlMapper.get(urlId);
    }

    public String getUrl(UrlId urlId) {
        UrlInfo urlInfo = this.urlMapper.get(urlId);
        assert (urlInfo.method() == Method.POST || urlInfo.arguments().isEmpty());
        return urlInfo.url();
    }

    public String buildUrl(UrlId urlId, Map<String, String> arguments) {
        UrlInfo urlInfo = this.urlMapper.get(urlId);
        return this.buildUrl(urlInfo, arguments);
    }

    public String buildUrl(UrlInfo urlInfo, Map<String, String> arguments) {
        assert (arguments.keySet().equals(new HashSet<String>(urlInfo.arguments()))) : "Arguments mismatch for " + urlInfo.url + ", expected: " + String.valueOf(urlInfo.arguments()) + " got: " + String.valueOf(arguments.keySet());
        return arguments.keySet().stream().reduce(urlInfo.url(), (str, argKey) -> str.replaceAll("%\\{" + argKey + "\\}", StringUtils.encodeUrl(urlInfo.encoding().encode((String)arguments.get(argKey)))));
    }

    @Override
    public void reloadData() {
    }

    public void loadUrls() {
        this.urlMappersByType.clear();
        this.urlMapper = UrlMapper.EMPTY;
        if (this.urlListOverride.get() == null) {
            UrlInfo urlInfo;
            this.readEmbeddedUrls();
            if (!this.ignoreCache.get().booleanValue()) {
                this.readLocalUrlCache();
            }
            if ((urlInfo = this.urlMappersByType.getOrDefault((Object)UrlMapperType.BUNDLED, this.urlMappersByType.getOrDefault((Object)UrlMapperType.LOCAL_CACHE, UrlMapper.EMPTY)).get(UrlId.DATA_STATIC_URLS)) == null) {
                WynntilsMod.error("ERROR: Failed to load baseline URL list. Try deleting Wynntils cache.");
                throw new RuntimeException("Missing DATA_STATIC_URLS from cached and bundled urls.json");
            }
            URI uri = URI.create(urlInfo.url());
            this.downloadAndReadRemoteUrls(uri);
        } else {
            this.readEmbeddedUrls();
            if (!this.ignoreCache.get().booleanValue()) {
                this.readLocalUrlCache();
            }
            this.downloadAndReadRemoteUrls(this.urlListOverride.get());
        }
    }

    private void readEmbeddedUrls() {
        try {
            this.readInputStreamForUrl(this.getBundledInputStream(), UrlMapperType.BUNDLED);
        }
        catch (JsonSyntaxException | IOException e) {
            throw new RuntimeException("ERROR: Bundled JSON has invalid syntax or is malformed, or it could not be read. This might be because of a corrupt download. Try updating Wynntils.", e);
        }
    }

    private void readLocalUrlCache() {
        Pair<FileInputStream, File> localCache = this.getLocalCacheInputStreams();
        if (localCache != null) {
            try {
                this.readInputStreamForUrl(localCache.key(), UrlMapperType.LOCAL_CACHE);
            }
            catch (JsonSyntaxException | IOException e) {
                WynntilsMod.warn("Problem reading URL list from local cache, deleting it.", e);
                FileUtils.deleteFile(localCache.value());
            }
        }
    }

    private void downloadAndReadRemoteUrls(URI uri) {
        String localFileName = UrlId.DATA_STATIC_URLS.getId();
        Download dl = Managers.Net.download(uri, localFileName);
        dl.handleInputStream(inputStream -> {
            try {
                UrlMapper urlMapper = this.readUrlMapper((InputStream)inputStream);
                this.urlMappersByType.put(UrlMapperType.REMOTE, urlMapper);
                this.mergeUrlMappers();
            }
            catch (IllegalStateException e) {
                WynntilsMod.error("Critical error while updating URL list from online source", e);
                throw e;
            }
            catch (IOException e) {
                WynntilsMod.warn("Problem updating URL list from online source", e);
                this.mergeUrlMappers();
            }
        }, throwable -> WynntilsMod.warn("Failed to download URL list from online source", throwable));
    }

    private void readInputStreamForUrl(InputStream tryStream, UrlMapperType listType) throws JsonSyntaxException, IOException {
        try (InputStream inputStream = tryStream;){
            UrlMapper urlMapper = this.readUrlMapper(inputStream);
            this.urlMappersByType.put(listType, urlMapper);
        }
        catch (MalformedJsonException e) {
            throw new MalformedJsonException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeUrlMappers() {
        UrlMapper urlMapper = this.urlMapper;
        synchronized (urlMapper) {
            int currentVersion = -1;
            LinkedHashMap<UrlId, UrlInfo> currentUrls = new LinkedHashMap<UrlId, UrlInfo>();
            UrlMapper bundledList = this.urlMappersByType.get((Object)UrlMapperType.BUNDLED);
            if (this.urlMapperForceType.get() == null || this.urlMapperForceType.get() == UrlMapperType.BUNDLED) {
                currentVersion = bundledList.version();
                currentUrls.putAll(bundledList.urls());
            }
            if (this.debugLogs.get().booleanValue()) {
                WynntilsMod.info("Bundled URL list version: " + currentVersion + ", URLs: " + currentUrls.size());
            }
            if (this.urlMapperForceType.get() == null || this.urlMapperForceType.get() == UrlMapperType.LOCAL_CACHE) {
                currentVersion = this.checkLocalCache(currentVersion, currentUrls);
            }
            if (this.urlMapperForceType.get() == null || this.urlMapperForceType.get() == UrlMapperType.REMOTE) {
                currentVersion = this.checkRemoteList(currentVersion, currentUrls);
            }
            this.urlMapper = new UrlMapper(currentVersion, currentUrls);
        }
        if (this.urlMapper.urls().isEmpty()) {
            throw new IllegalStateException("     URL list is empty after merging. This means all three of the URL sources failed to load.\n     If you have set a custom url loading mode, this means that it failed to load.\n     Otherwise, this is a critical error, try contacting the developers.\n");
        }
        WynntilsMod.info("Merged URL list. Version: " + this.urlMapper.version + ", URLs: " + this.urlMapper.urls.size());
        WynntilsMod.postEventOnMainThread(new UrlProcessingFinishedEvent());
        WynntilsMod.reloadAllComponentData();
    }

    private int checkLocalCache(int currentVersion, Map<UrlId, UrlInfo> currentUrls) {
        if (this.urlMappersByType.containsKey((Object)UrlMapperType.LOCAL_CACHE)) {
            UrlMapper localCacheList = this.urlMappersByType.get((Object)UrlMapperType.LOCAL_CACHE);
            if (localCacheList.version() >= currentVersion) {
                currentVersion = localCacheList.version();
                localCacheList.urls.entrySet().stream().filter(entry -> !currentUrls.containsKey(entry.getKey())).forEach(entry -> currentUrls.put((UrlId)((Object)((Object)entry.getKey())), (UrlInfo)entry.getValue()));
                localCacheList.urls().forEach((key, value) -> {
                    if (!currentUrls.containsKey(key)) {
                        return;
                    }
                    UrlInfo urlInfo = (UrlInfo)currentUrls.get(key);
                    if (!urlInfo.md5().equals(value.md5())) {
                        currentUrls.put((UrlId)((Object)key), value.withoutMd5());
                        if (this.debugLogs.get().booleanValue()) {
                            WynntilsMod.info("Bundled and local hashes differ for " + String.valueOf(key) + ". Removing hash. (" + urlInfo.md5().orElse("null") + " -> null)");
                        }
                    }
                });
            }
        } else {
            WynntilsMod.warn("No URL cache found. This is normal if you are running Wynntils for the first time. Otherwise, this likely indicates a problem.");
        }
        return currentVersion;
    }

    private int checkRemoteList(int currentVersion, Map<UrlId, UrlInfo> currentUrls) {
        if (this.urlMappersByType.containsKey((Object)UrlMapperType.REMOTE)) {
            UrlMapper remoteList = this.urlMappersByType.get((Object)UrlMapperType.REMOTE);
            if (remoteList.version() < currentVersion) {
                throw new IllegalStateException("Remote URL list has a lower version than the local cache. This should not happen.");
            }
            currentVersion = remoteList.version();
            remoteList.urls().forEach((key, value) -> {
                if (currentUrls.containsKey(key)) {
                    UrlInfo oldInfo = currentUrls.put((UrlId)((Object)key), (UrlInfo)value);
                    if (this.debugLogs.get().booleanValue() && oldInfo != null && !oldInfo.md5().equals(value.md5())) {
                        WynntilsMod.info("Remote hash differs for " + String.valueOf(key) + ". Using remote hash. (" + String.valueOf(oldInfo.md5()) + " -> " + value.md5().orElse("null") + ")");
                    }
                } else {
                    currentUrls.put((UrlId)((Object)key), (UrlInfo)value);
                }
            });
        } else {
            WynntilsMod.warn("No remote URL list available. Falling back to local sources.");
        }
        return currentVersion;
    }

    private InputStream getBundledInputStream() {
        return WynntilsMod.getModResourceAsStream("urls.json");
    }

    private Pair<FileInputStream, File> getLocalCacheInputStreams() {
        File cacheFile = Managers.Net.getCacheFile(UrlId.DATA_STATIC_URLS.getId());
        if (cacheFile.exists() && cacheFile.length() > 0L) {
            try {
                return Pair.of(new FileInputStream(cacheFile), cacheFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private UrlMapper readUrlMapper(InputStream inputStream) throws IOException, JsonSyntaxException {
        byte[] data = inputStream.readAllBytes();
        String json = new String(data, StandardCharsets.UTF_8);
        Type type = new TypeToken<List<UrlProfile>>(this){}.getType();
        List urlProfiles = (List)WynntilsMod.GSON.fromJson(json, type);
        HashMap<UrlId, UrlInfo> newMap = new HashMap<UrlId, UrlInfo>();
        int version = 0;
        for (UrlProfile urlProfile : urlProfiles) {
            if (urlProfile.version != 0) {
                version = urlProfile.version;
                continue;
            }
            List<String> arguments = urlProfile.arguments == null ? List.of() : urlProfile.arguments;
            Object urlId = UrlId.from(urlProfile.id);
            if (((Optional)urlId).isEmpty()) continue;
            newMap.put((UrlId)((Object)((Optional)urlId).get()), new UrlInfo(urlProfile.url, arguments, Method.from(urlProfile.method), Encoding.from(urlProfile.encoding), Optional.ofNullable(urlProfile.md5)));
        }
        for (Object urlId : UrlId.values()) {
            if (newMap.containsKey(urlId)) continue;
            WynntilsMod.warn("Missing URL in urls.json: " + String.valueOf(urlId));
            return UrlMapper.EMPTY;
        }
        return new UrlMapper(version, newMap);
    }

    private static enum UrlMapperType {
        BUNDLED,
        LOCAL_CACHE,
        REMOTE;

    }

    private record UrlMapper(int version, Map<UrlId, UrlInfo> urls) {
        public static final UrlMapper EMPTY = new UrlMapper(-1, Map.of());

        public UrlInfo get(UrlId urlId) {
            return this.urls.get((Object)urlId);
        }
    }

    public record UrlInfo(String url, List<String> arguments, Method method, Encoding encoding, Optional<String> md5) {
        public UrlInfo withoutMd5() {
            return new UrlInfo(this.url, this.arguments, this.method, this.encoding, Optional.empty());
        }
    }

    public static enum Method {
        GET,
        POST;


        private static Method from(String str) {
            if (str == null || str.isEmpty()) {
                return GET;
            }
            return Method.valueOf(str.toUpperCase(Locale.ROOT));
        }
    }

    private static final class UrlProfile {
        int version;
        String id;
        String url;
        String method;
        List<String> arguments;
        String md5;
        String encoding;

        private UrlProfile() {
        }
    }

    public static enum Encoding {
        NONE(s -> s),
        CARGO(s -> "'" + s.replace("'", "\\'") + "'"),
        WIKI(s -> s.replace(" ", "_"));

        private final Function<String, String> encoder;

        private Encoding(Function<String, String> encoder) {
            this.encoder = encoder;
        }

        private static Encoding from(String str) {
            if (str == null || str.isEmpty()) {
                return NONE;
            }
            return Encoding.valueOf(str.toUpperCase(Locale.ROOT));
        }

        String encode(String input) {
            return this.encoder.apply(input);
        }
    }
}

