/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.persisted;

import com.google.common.base.CaseFormat;
import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.PersistedOwner;
import com.wynntils.core.persisted.PersistedValue;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.NullableConfig;
import com.wynntils.core.persisted.type.PersistedMetadata;
import com.wynntils.utils.type.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class PersistedManager
extends Manager {
    private final Map<PersistedValue<?>, PersistedMetadata<?>> metadatas = new HashMap();
    private final Set<PersistedValue<?>> persisteds = new TreeSet();

    public PersistedManager() {
        super(List.of());
    }

    public <T> void setRaw(PersistedValue<T> persisted, Object value) {
        persisted.setWithoutTouch(value);
    }

    public void registerOwner(PersistedOwner owner) {
        this.verifyAnnotations(owner);
        HashMap newMetadatas = new HashMap();
        this.getPersisted(owner, Config.class).forEach(p -> {
            Config configObj;
            Field configField = (Field)p.a();
            try {
                configObj = (Config)FieldUtils.readField((Field)configField, (Object)owner, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot read persisted field: " + String.valueOf(configField), e);
            }
            PersistedMetadata metadata = this.createMetadata(configObj, owner, configField, (Persisted)p.b());
            newMetadatas.put(configObj, metadata);
        });
        this.metadatas.putAll(newMetadatas);
        this.persisteds.addAll(newMetadatas.keySet());
    }

    public List<Pair<Field, Persisted>> getPersisted(PersistedOwner owner, Class<? extends PersistedValue> clazzType) {
        return Arrays.stream(FieldUtils.getFieldsWithAnnotation(owner.getClass(), Persisted.class)).filter(field -> clazzType.isAssignableFrom(field.getType())).map(field -> Pair.of(field, field.getAnnotation(Persisted.class))).toList();
    }

    public void verifyAnnotations(PersistedOwner owner) {
        Arrays.stream(FieldUtils.getFieldsWithAnnotation(owner.getClass(), Persisted.class)).forEach(field -> {
            if (!PersistedValue.class.isAssignableFrom(field.getType())) {
                throw new RuntimeException("A non-persistable class was marked with @Persisted annotation: " + String.valueOf(field));
            }
        });
        FieldUtils.getAllFieldsList(owner.getClass()).stream().filter(field -> PersistedValue.class.isAssignableFrom(field.getType())).forEach(field -> {
            Persisted annotation = field.getAnnotation(Persisted.class);
            if (annotation == null) {
                throw new RuntimeException("A persisted datatype is missing @Persisted annotation:" + String.valueOf(field));
            }
        });
    }

    public <T> PersistedMetadata<T> getMetadata(PersistedValue<T> persisted) {
        return this.metadatas.get(persisted);
    }

    private <T> PersistedMetadata<T> createMetadata(PersistedValue<T> persisted, PersistedOwner owner, Field configField, Persisted annotation) {
        Class clazz;
        boolean allowNull;
        Type valueType = Managers.Json.getJsonValueType(configField);
        String fieldName = configField.getName();
        String i18nKeyOverride = annotation.i18nKey();
        T defaultValue = Managers.Json.deepCopy(persisted.get(), valueType);
        boolean bl = allowNull = valueType instanceof Class && NullableConfig.class.isAssignableFrom(clazz = (Class)valueType);
        if (defaultValue == null && !allowNull) {
            throw new RuntimeException("Default config value is null in " + owner.getJsonName() + "." + fieldName);
        }
        String jsonName = this.getPrefix(owner) + owner.getJsonName() + "." + fieldName;
        return new PersistedMetadata<T>(owner, fieldName, valueType, defaultValue, i18nKeyOverride, allowNull, jsonName);
    }

    private String getPrefix(PersistedOwner owner) {
        if (!(owner instanceof Overlay)) {
            return "";
        }
        Overlay overlay = (Overlay)owner;
        String name = overlay.getDeclaringFeatureClassName();
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, name) + ".";
    }
}

