/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.properties;

import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;

public class Property<T> {
    private final Manager ownerManager;
    private final Class<T> clazz;
    private final String propertyPath;
    private final T defaultValue;
    private boolean loaded;
    private T jvmArgValue;

    public Property(Manager ownerManager, Class<T> clazz, String propertyPath, T defaultValue) {
        this.ownerManager = ownerManager;
        this.clazz = clazz;
        this.propertyPath = propertyPath;
        this.defaultValue = defaultValue;
        this.loaded = false;
        this.jvmArgValue = null;
    }

    public T get() {
        if (!this.loaded) {
            this.loadJvmArgValue();
        }
        return this.jvmArgValue != null ? this.jvmArgValue : this.defaultValue;
    }

    public Class<T> getClassType() {
        return this.clazz;
    }

    String getFullJvmArgumentPath() {
        return "wynntils." + this.ownerManager.getTranslationKeyName() + "." + this.propertyPath;
    }

    private void loadJvmArgValue() {
        this.jvmArgValue = Managers.SystemProperties.loadJvmArg(this);
        this.loaded = true;
    }
}

