/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.text;

import com.wynntils.core.text.FontLookup;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.utils.colors.CustomColor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5251;

public final class PartStyle {
    private static final String STYLE_PREFIX = "\u00a7";
    private static final Int2ObjectMap<class_124> INTEGER_TO_CHATFORMATTING_MAP = (Int2ObjectMap)Arrays.stream(class_124.values()).filter(class_124::method_543).collect(() -> new Int2ObjectOpenHashMap(class_124.values().length), (map, cf) -> map.put(cf.method_532() | 0xFF000000, cf), Map::putAll);
    private final StyledTextPart owner;
    private final CustomColor color;
    private final CustomColor shadowColor;
    private final boolean obfuscated;
    private final boolean bold;
    private final boolean strikethrough;
    private final boolean underlined;
    private final boolean italic;
    private final class_2558 clickEvent;
    private final class_2568 hoverEvent;
    private final class_2960 font;

    private PartStyle(StyledTextPart owner, CustomColor color, CustomColor shadowColor, boolean obfuscated, boolean bold, boolean strikethrough, boolean underlined, boolean italic, class_2558 clickEvent, class_2568 hoverEvent, class_2960 font) {
        this.owner = owner;
        this.color = color;
        this.shadowColor = shadowColor;
        this.obfuscated = obfuscated;
        this.bold = bold;
        this.strikethrough = strikethrough;
        this.underlined = underlined;
        this.italic = italic;
        this.clickEvent = clickEvent;
        this.hoverEvent = hoverEvent;
        this.font = font;
    }

    PartStyle(PartStyle partStyle, StyledTextPart owner) {
        this.owner = owner;
        this.color = partStyle.color;
        this.shadowColor = partStyle.shadowColor;
        this.obfuscated = partStyle.obfuscated;
        this.bold = partStyle.bold;
        this.strikethrough = partStyle.strikethrough;
        this.underlined = partStyle.underlined;
        this.italic = partStyle.italic;
        this.clickEvent = partStyle.clickEvent;
        this.hoverEvent = partStyle.hoverEvent;
        this.font = partStyle.font;
    }

    static PartStyle fromStyle(class_2583 style, StyledTextPart owner, class_2583 parentStyle) {
        class_2583 inheritedStyle = parentStyle == null ? style : style.method_27702(parentStyle);
        return new PartStyle(owner, inheritedStyle.method_10973() == null ? CustomColor.NONE : CustomColor.fromInt(inheritedStyle.method_10973().method_27716() | 0xFF000000), inheritedStyle.method_65301() == null ? CustomColor.NONE : CustomColor.fromInt(inheritedStyle.method_65301() | 0xFF000000), inheritedStyle.method_10987(), inheritedStyle.method_10984(), inheritedStyle.method_10986(), inheritedStyle.method_10965(), inheritedStyle.method_10966(), inheritedStyle.method_10970(), inheritedStyle.method_10969(), inheritedStyle.method_27708());
    }

    public String asString(PartStyle previousStyle, StyleType type) {
        if (!type.includeBasicFormatting()) {
            return "";
        }
        StringBuilder styleString = new StringBuilder();
        boolean skipFormatting = false;
        if (previousStyle != null && (this.color == CustomColor.NONE || previousStyle.color.equals(this.color))) {
            String differenceString = this.tryConstructDifference(previousStyle, type);
            if (differenceString != null) {
                styleString.append(differenceString);
                skipFormatting = true;
            } else {
                styleString.append(STYLE_PREFIX).append(class_124.field_1070.method_36145());
            }
        }
        if (!skipFormatting) {
            if (this.color != CustomColor.NONE) {
                class_124 chatFormatting = (class_124)INTEGER_TO_CHATFORMATTING_MAP.get(this.color.asInt());
                if (chatFormatting != null) {
                    styleString.append(STYLE_PREFIX).append(chatFormatting.method_36145());
                } else {
                    styleString.append(STYLE_PREFIX).append(this.color.toHexString());
                }
            }
            if (this.obfuscated) {
                styleString.append(STYLE_PREFIX).append(class_124.field_1051.method_36145());
            }
            if (this.bold) {
                styleString.append(STYLE_PREFIX).append(class_124.field_1067.method_36145());
            }
            if (this.strikethrough) {
                styleString.append(STYLE_PREFIX).append(class_124.field_1055.method_36145());
            }
            if (this.underlined) {
                styleString.append(STYLE_PREFIX).append(class_124.field_1073.method_36145());
            }
            if (this.italic) {
                styleString.append(STYLE_PREFIX).append(class_124.field_1056.method_36145());
            }
            if (type.includeFonts() && this.font != null && !this.font.toString().equals("minecraft:default")) {
                String fontCode = FontLookup.getFontCodeFromFont(this.font);
                styleString.append(STYLE_PREFIX).append("{f:").append(fontCode).append("}");
            }
            if (type.includeEvents()) {
                if (this.clickEvent != null) {
                    styleString.append(STYLE_PREFIX).append("[").append(this.owner.getParent().getClickEventIndex(this.clickEvent)).append("]");
                }
                if (this.hoverEvent != null) {
                    styleString.append(STYLE_PREFIX).append("<").append(this.owner.getParent().getHoverEventIndex(this.hoverEvent)).append(">");
                }
            }
        }
        return styleString.toString();
    }

    public class_2583 getStyle() {
        class_5251 textColor = this.color == CustomColor.NONE ? null : class_5251.method_27717((int)(this.color.asInt() & 0xFFFFFF));
        Integer shadowColorInt = this.shadowColor == CustomColor.NONE ? null : Integer.valueOf(this.shadowColor.asInt() & 0xFFFFFF);
        return new class_2583(textColor, shadowColorInt, Boolean.valueOf(this.bold), Boolean.valueOf(this.italic), Boolean.valueOf(this.underlined), Boolean.valueOf(this.strikethrough), Boolean.valueOf(this.obfuscated), this.clickEvent, this.hoverEvent, null, this.font);
    }

    public PartStyle withColor(class_124 color) {
        if (!color.method_543()) {
            throw new IllegalArgumentException("ChatFormatting " + String.valueOf(color) + " is not a color!");
        }
        CustomColor newColor = CustomColor.fromInt(color.method_532() | 0xFF000000);
        return new PartStyle(this.owner, newColor, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withColor(CustomColor color) {
        return new PartStyle(this.owner, color, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isObfuscated() {
        return this.obfuscated;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public class_2558 getClickEvent() {
        return this.clickEvent;
    }

    public class_2568 getHoverEvent() {
        return this.hoverEvent;
    }

    public CustomColor getColor() {
        return this.color;
    }

    public CustomColor getShadowColor() {
        return this.shadowColor;
    }

    public class_2960 getFont() {
        return this.font;
    }

    public PartStyle withShadowColor(CustomColor shadowColor) {
        return new PartStyle(this.owner, this.color, shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withBold(boolean bold) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withObfuscated(boolean obfuscated) {
        return new PartStyle(this.owner, this.color, this.shadowColor, obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withStrikethrough(boolean strikethrough) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, this.bold, strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withUnderlined(boolean underlined) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withItalic(boolean italic) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, italic, this.clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withClickEvent(class_2558 clickEvent) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, clickEvent, this.hoverEvent, this.font);
    }

    public PartStyle withHoverEvent(class_2568 hoverEvent) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, hoverEvent, this.font);
    }

    public PartStyle withFont(class_2960 font) {
        return new PartStyle(this.owner, this.color, this.shadowColor, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, font);
    }

    private String tryConstructDifference(PartStyle oldStyle, StyleType type) {
        StringBuilder add = new StringBuilder();
        int oldColorInt = oldStyle.color.asInt();
        int newColorInt = this.color.asInt();
        if (oldColorInt == -1) {
            if (newColorInt != -1) {
                Arrays.stream(class_124.values()).filter(c -> c.method_543() && newColorInt == (c.method_532() | 0xFF000000)).findFirst().ifPresent(add::append);
            }
        } else if (oldColorInt != newColorInt) {
            return null;
        }
        if (oldStyle.obfuscated && !this.obfuscated) {
            return null;
        }
        if (!oldStyle.obfuscated && this.obfuscated) {
            add.append(class_124.field_1051);
        }
        if (oldStyle.bold && !this.bold) {
            return null;
        }
        if (!oldStyle.bold && this.bold) {
            add.append(class_124.field_1067);
        }
        if (oldStyle.strikethrough && !this.strikethrough) {
            return null;
        }
        if (!oldStyle.strikethrough && this.strikethrough) {
            add.append(class_124.field_1055);
        }
        if (oldStyle.underlined && !this.underlined) {
            return null;
        }
        if (!oldStyle.underlined && this.underlined) {
            add.append(class_124.field_1073);
        }
        if (oldStyle.italic && !this.italic) {
            return null;
        }
        if (!oldStyle.italic && this.italic) {
            add.append(class_124.field_1056);
        }
        if (type.includeFonts()) {
            if (oldStyle.font != null && this.font == null) {
                return null;
            }
            if (this.font != null) {
                String fontCode = FontLookup.getFontCodeFromFont(this.font);
                add.append(STYLE_PREFIX).append("{f:").append(fontCode).append("}");
            }
        }
        if (type.includeEvents()) {
            if (oldStyle.clickEvent != null && this.clickEvent == null) {
                return null;
            }
            if (oldStyle.clickEvent != this.clickEvent) {
                add.append(STYLE_PREFIX).append("[").append(this.owner.getParent().getClickEventIndex(this.clickEvent)).append("]");
            }
            if (oldStyle.hoverEvent != null && this.hoverEvent == null) {
                return null;
            }
            if (oldStyle.hoverEvent != this.hoverEvent) {
                add.append(STYLE_PREFIX).append("<").append(this.owner.getParent().getHoverEventIndex(this.hoverEvent)).append(">");
            }
        }
        return add.toString();
    }

    public String toString() {
        return "PartStyle{color=" + String.valueOf(this.color) + ", obfuscated=" + this.obfuscated + ", bold=" + this.bold + ", strikethrough=" + this.strikethrough + ", underlined=" + this.underlined + ", italic=" + this.italic + ", clickEvent=" + String.valueOf(this.clickEvent) + ", hoverEvent=" + String.valueOf(this.hoverEvent) + ", font=" + String.valueOf(this.font) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartStyle partStyle = (PartStyle)o;
        return this.obfuscated == partStyle.obfuscated && this.bold == partStyle.bold && this.strikethrough == partStyle.strikethrough && this.underlined == partStyle.underlined && this.italic == partStyle.italic && Objects.equals(this.color, partStyle.color) && Objects.equals(this.clickEvent, partStyle.clickEvent) && Objects.equals(this.hoverEvent, partStyle.hoverEvent) && Objects.equals(this.font, partStyle.font);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.font);
    }
}

