/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.chat;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.AddGuiMessageLineEvent;
import com.wynntils.mc.event.ChatComponentRenderEvent;
import com.wynntils.mc.extension.GuiMessageExtension;
import com.wynntils.mc.extension.GuiMessageLineExtension;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.Pair;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_303;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.CHAT)
public class ChatTimestampFeature
extends Feature {
    @Persisted
    private final Config<String> formatPattern = new Config<String>("HH:mm:ss");
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern((String)this.formatPattern.get(), Locale.ROOT);
    private int timestampWidth = 0;

    @Override
    protected void onConfigUpdate(Config<?> config) {
        try {
            this.formatter = DateTimeFormatter.ofPattern((String)this.formatPattern.get(), Locale.ROOT);
        }
        catch (Exception e) {
            this.formatter = null;
            McUtils.sendErrorToClient(class_1074.method_4662((String)"feature.wynntils.chatTimestamp.invalidFormatMsg", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    public void onGuiMessageLineAdd(AddGuiMessageLineEvent event) {
        GuiMessageExtension messageExtension = (GuiMessageExtension)event.getMessage();
        ((GuiMessageLineExtension)event.getLine()).setCreated(messageExtension.getCreated());
        if (event.getIndex() != 0 || this.formatter == null) {
            return;
        }
        GuiMessageLineExtension extension = (GuiMessageLineExtension)event.getLine();
        extension.setTimestamp((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)extension.getCreated().format(this.formatter)).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"] ").method_27692(class_124.field_1063)));
    }

    @SubscribeEvent
    public void onChatComponentRenderPre(ChatComponentRenderEvent.Pre event) {
        this.timestampWidth = 0;
        for (class_303.class_7590 line : event.getChatComponent().field_2064) {
            GuiMessageLineExtension extension = (GuiMessageLineExtension)line;
            Optional<Pair<class_2561, Integer>> timestamp = extension.getTimestamp();
            if (timestamp.isEmpty()) continue;
            this.timestampWidth = Math.max(this.timestampWidth, timestamp.get().b());
        }
    }

    @SubscribeEvent
    public void onChatComponentTranslate(ChatComponentRenderEvent.Translate event) {
        if (this.timestampWidth != 0) {
            event.setX(event.getX() + 4.0f + (float)this.timestampWidth);
        }
    }

    @SubscribeEvent
    public void onChatComponentMapMouseX(ChatComponentRenderEvent.MapMouseX event) {
        if (this.timestampWidth != 0) {
            event.setX(event.getX() - (double)(4 + this.timestampWidth));
        }
    }

    @SubscribeEvent
    public void onChatComponentRenderBackground(ChatComponentRenderEvent.Background event) {
        if (this.timestampWidth == 0) {
            return;
        }
        event.getGuiGraphics().method_51448().method_22903();
        event.getGuiGraphics().method_51448().method_46416((float)(-(this.timestampWidth + 4)), 0.0f, 0.0f);
        event.getGuiGraphics().method_25294(-2, event.getRenderX() - event.getLineHeight(), this.timestampWidth - 2, event.getRenderX(), event.getOpacity() << 24);
        event.getGuiGraphics().method_51448().method_22909();
    }

    @SubscribeEvent
    public void onnChatComponentRenderText(ChatComponentRenderEvent.Text event) {
        if (this.timestampWidth == 0) {
            return;
        }
        GuiMessageLineExtension extension = (GuiMessageLineExtension)event.getLine();
        if (extension.getTimestamp().isEmpty()) {
            return;
        }
        event.getGuiGraphics().method_51448().method_22903();
        event.getGuiGraphics().method_51448().method_46416(-((float)extension.getTimestamp().get().b().intValue() + 4.0f), 0.0f, 0.0f);
        event.getGuiGraphics().method_27535(event.getFont(), extension.getTimestamp().get().a(), 0, event.getRenderY(), 0xFFFFFF + (event.getTextOpacity() << 24));
        event.getGuiGraphics().method_51448().method_22909();
    }
}

