/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.chat;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.ChatScreenKeyTypedEvent;
import com.wynntils.mc.event.ChatScreenSendEvent;
import com.wynntils.mc.event.CommandSentEvent;
import com.wynntils.mc.event.EditBoxInsertEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.models.wynnalphabet.WynnAlphabet;
import com.wynntils.screens.transcription.widgets.WynnAlphabetButton;
import com.wynntils.utils.mc.McUtils;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.CHAT)
public class InputTranscriptionFeature
extends Feature {
    @Persisted
    private final Config<Boolean> transcriptionButtons = new Config<Boolean>(true);
    private static final int MAX_CHAT_LENGTH = 256;
    private static final int MAX_TRANSCRIPTABLE_NUMBER = 5000;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre event) {
        if (!((Boolean)this.transcriptionButtons.get()).booleanValue()) {
            return;
        }
        class_437 class_4372 = event.getScreen();
        if (class_4372 instanceof class_408) {
            class_408 chatScreen = (class_408)class_4372;
            chatScreen.field_22789 -= 45;
            int xOffset = chatScreen.field_22789 + 1;
            this.addAlphabetButton(chatScreen, xOffset, WynnAlphabet.DEFAULT);
            this.addAlphabetButton(chatScreen, xOffset += 15, WynnAlphabet.WYNNIC);
            this.addAlphabetButton(chatScreen, xOffset += 15, WynnAlphabet.GAVELLIAN);
        }
    }

    @SubscribeEvent
    public void onEditBoxInsert(EditBoxInsertEvent event) {
        class_437 class_4372 = McUtils.mc().field_1755;
        if (!(class_4372 instanceof class_408)) {
            return;
        }
        class_408 chatScreen = (class_408)class_4372;
        if (!((Boolean)this.transcriptionButtons.get()).booleanValue()) {
            return;
        }
        if (event.getTextToWrite().isBlank()) {
            return;
        }
        WynnAlphabet selectedAlphabet = Models.WynnAlphabet.getSelectedAlphabet();
        if (selectedAlphabet == WynnAlphabet.DEFAULT) {
            return;
        }
        Matcher numMatcher = NUMBER_PATTERN.matcher(event.getTextToWrite());
        if (numMatcher.matches()) {
            if (selectedAlphabet != WynnAlphabet.WYNNIC) {
                return;
            }
            this.handleTypedNumber(Integer.parseInt(event.getTextToWrite()), Models.WynnAlphabet.getWynnicNumbers(), event, chatScreen);
        } else {
            List<Character> replacementList = selectedAlphabet == WynnAlphabet.GAVELLIAN ? Models.WynnAlphabet.getGavellianCharacters() : Models.WynnAlphabet.getWynnicCharacters();
            this.handleTypedCharacter(event.getTextToWrite(), replacementList, event, chatScreen);
        }
    }

    @SubscribeEvent
    public void onChatScreenKeyTyped(ChatScreenKeyTypedEvent event) {
        if (event.getKeyCode() != 259) {
            return;
        }
        class_437 class_4372 = McUtils.mc().field_1755;
        if (!(class_4372 instanceof class_408)) {
            return;
        }
        class_408 chatScreen = (class_408)class_4372;
        if (!((Boolean)this.transcriptionButtons.get()).booleanValue()) {
            return;
        }
        if (!chatScreen.field_2382.method_1866().isBlank()) {
            return;
        }
        String beforeCursor = chatScreen.field_2382.method_1882().substring(0, chatScreen.field_2382.method_1881());
        String afterCursor = chatScreen.field_2382.method_1882().substring(chatScreen.field_2382.method_1881());
        if (beforeCursor.isBlank() || !Models.WynnAlphabet.getWynnicNumbers().contains(Character.valueOf(beforeCursor.charAt(beforeCursor.length() - 1)))) {
            return;
        }
        String currentNumsStr = this.getWynnicNumBeforeCursor(beforeCursor);
        int wynnicNum = Models.WynnAlphabet.wynnicNumToInt(currentNumsStr);
        String backspacedNum = String.valueOf(wynnicNum);
        if (backspacedNum.length() > 1) {
            event.setCanceled(true);
            backspacedNum = backspacedNum.substring(0, backspacedNum.length() - 1);
            int index = beforeCursor.lastIndexOf(currentNumsStr);
            beforeCursor = beforeCursor.substring(0, index);
            this.updateInput(beforeCursor, afterCursor, Integer.parseInt(backspacedNum), chatScreen.field_2382);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onChatScreenSend(ChatScreenSendEvent event) {
        if (event.getInput().isBlank()) {
            return;
        }
        String message = event.getInput();
        if (!Models.WynnAlphabet.containsBrackets(message)) {
            return;
        }
        String updatedMessage = Models.WynnAlphabet.transcribeBracketedText(message);
        if ((updatedMessage = updatedMessage.substring(0, Math.min(updatedMessage.length(), 256))).equals(message)) {
            return;
        }
        event.setCanceled(true);
        Services.ChatTab.sendChat(updatedMessage);
        Models.WynnAlphabet.setSelectedAlphabet(WynnAlphabet.DEFAULT);
    }

    @SubscribeEvent
    public void onCommandSent(CommandSentEvent event) {
        String command = event.getCommand();
        if (Models.WynnAlphabet.containsBrackets(command)) {
            String updatedCommand = Models.WynnAlphabet.transcribeBracketedText(command);
            if (!(updatedCommand = updatedCommand.substring(0, Math.min(updatedCommand.length(), 256))).equals(command)) {
                event.setCanceled(true);
                Handlers.Command.sendCommandImmediately(updatedCommand);
            }
        }
        Models.WynnAlphabet.setSelectedAlphabet(WynnAlphabet.DEFAULT);
    }

    private void addAlphabetButton(class_408 chatScreen, int xOffset, WynnAlphabet alphabet) {
        chatScreen.method_37063((class_364)new WynnAlphabetButton(xOffset, chatScreen.field_22790 - 14, 12, 12, alphabet));
    }

    private void handleTypedCharacter(String typedChar, List<Character> replacementList, EditBoxInsertEvent event, class_408 chatScreen) {
        int engIndex = Models.WynnAlphabet.getEnglishCharacters().indexOf(Character.valueOf(typedChar.toLowerCase(Locale.ROOT).charAt(0)));
        if (engIndex == -1) {
            return;
        }
        if (engIndex >= replacementList.size()) {
            return;
        }
        String replaced = String.valueOf(replacementList.get(engIndex));
        event.setCanceled(true);
        chatScreen.field_2382.method_1867(replaced);
    }

    private void handleTypedNumber(int typedNumber, List<Character> replacementList, EditBoxInsertEvent event, class_408 chatScreen) {
        String input = chatScreen.field_2382.method_1882();
        String beforeCursor = input.substring(0, chatScreen.field_2382.method_1881());
        String afterCursor = input.substring(chatScreen.field_2382.method_1881());
        if (input.isBlank() || !Models.WynnAlphabet.getWynnicNumbers().contains(Character.valueOf(beforeCursor.charAt(beforeCursor.length() - 1)))) {
            int numIndex = Models.WynnAlphabet.getEnglishNumbers().indexOf(typedNumber);
            if (numIndex == -1) {
                return;
            }
            event.setCanceled(true);
            String replaced = String.valueOf(replacementList.get(numIndex));
            chatScreen.field_2382.method_1867(replaced);
            return;
        }
        event.setCanceled(true);
        String currentNumsStr = this.getWynnicNumBeforeCursor(beforeCursor);
        int index = beforeCursor.lastIndexOf(currentNumsStr);
        beforeCursor = beforeCursor.substring(0, index);
        int updateNum = Models.WynnAlphabet.calculateWynnicNum(currentNumsStr, typedNumber);
        this.updateInput(beforeCursor, afterCursor, updateNum, chatScreen.field_2382);
    }

    private String getWynnicNumBeforeCursor(String beforeCursor) {
        StringBuilder currentNumsStr = new StringBuilder();
        List<Character> numbers = Models.WynnAlphabet.getWynnicNumbers();
        for (int i = beforeCursor.length() - 1; i >= 0 && numbers.contains(Character.valueOf(beforeCursor.charAt(i))); --i) {
            currentNumsStr.append(beforeCursor.charAt(i));
        }
        return currentNumsStr.reverse().toString();
    }

    private void updateInput(String beforeCursor, String afterCursor, int num, class_342 chatInput) {
        String transcriptedNum = num > 5000 ? "\u221e" : Models.WynnAlphabet.intToWynnicNum(num);
        String newInput = beforeCursor + transcriptedNum + afterCursor;
        if (newInput.length() > 256) {
            return;
        }
        int newCursorPos = beforeCursor.length() + transcriptedNum.length();
        chatInput.method_1852(newInput);
        chatInput.method_1883(newCursorPos, false);
    }
}

