/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.mc.event.BossHealthUpdateEvent;
import com.wynntils.mc.mixin.accessors.ClientboundBossEventPacketAccessor;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.type.IterationDecision;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2629;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMBAT)
public class AbbreviateMobHealthFeature
extends Feature {
    private static final Pattern MOB_HEALTH_PATTERN = Pattern.compile("(.*\u00a7[cb])(?<current>\\d+)(\u00a7.(?<max>\\/\\d+))?(\u00a7[cb4]\\s?\u2764.*)");

    @SubscribeEvent
    public void onHealthBarEvent(BossHealthUpdateEvent event) {
        class_2629 packet = event.getPacket();
        class_2629.class_5882 operation = ((ClientboundBossEventPacketAccessor)packet).getOperation();
        if (operation instanceof class_2629.class_5880) {
            class_2629.class_5880 addOperation = (class_2629.class_5880)operation;
            addOperation.field_29100 = this.transformHealthComponent(addOperation.field_29100);
            return;
        }
        if (operation instanceof class_2629.class_5884) {
            class_2629.class_5884 updateOperation = (class_2629.class_5884)operation;
            updateOperation.comp_2260 = this.transformHealthComponent(updateOperation.comp_2260);
            return;
        }
    }

    private class_2561 transformHealthComponent(class_2561 component) {
        String name = component.getString();
        Matcher healthMatcher = MOB_HEALTH_PATTERN.matcher(name);
        if (!healthMatcher.matches()) {
            return component;
        }
        StyledText styledText = StyledText.fromComponent(component);
        StyledText modified = styledText.iterate((part, changes) -> {
            String partStr = part.getString(null, StyleType.NONE);
            try {
                Object formattedHealth;
                if (partStr.equals(healthMatcher.group("current"))) {
                    rawHealth = Integer.parseInt(partStr);
                    formattedHealth = StringUtils.integerToShortString(rawHealth).toLowerCase(Locale.ROOT);
                } else if (partStr.equals(healthMatcher.group("max"))) {
                    rawHealth = Integer.parseInt(partStr.substring(1));
                    formattedHealth = "/" + StringUtils.integerToShortString(rawHealth).toLowerCase(Locale.ROOT);
                } else {
                    return IterationDecision.CONTINUE;
                }
                StyledTextPart newPart = new StyledTextPart((String)formattedHealth, part.getPartStyle().getStyle(), null, class_2583.field_24360);
                changes.remove(part);
                changes.add(newPart);
            }
            catch (NumberFormatException ignored) {
                return IterationDecision.CONTINUE;
            }
            return IterationDecision.CONTINUE;
        });
        if (modified.equals(styledText)) {
            return component;
        }
        return modified.getComponent();
    }
}

