/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.ContainerRenderEvent;
import com.wynntils.mc.event.DropHeldItemEvent;
import com.wynntils.models.containers.type.FullscreenContainerProperty;
import com.wynntils.models.items.items.game.MultiHealthPotionItem;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class ItemLockFeature
extends Feature {
    @RegisterKeyBind
    private final KeyBind lockSlotKeyBind = new KeyBind("Lock Slot", 72, true, null, this::tryChangeLockStateOnHoveredSlot);
    @Persisted
    private final HiddenConfig<Map<String, Set<Integer>>> classSlotLockMap = new HiddenConfig(new TreeMap());
    @Persisted
    private final Config<Boolean> blockAllActionsOnLockedItems = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> allowClickOnEmeraldPouchInBlockingMode = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> allowClickOnMultiHealthPotionsInBlockingMode = new Config<Boolean>(true);

    @SubscribeEvent
    public void onContainerRender(ContainerRenderEvent event) {
        class_465<?> abstractContainerScreen = event.getScreen();
        if (Models.Container.getCurrentContainer() instanceof FullscreenContainerProperty) {
            return;
        }
        for (Integer slotId : (Set)((Map)this.classSlotLockMap.get()).getOrDefault(Models.Character.getId(), new TreeSet())) {
            Optional<class_1735> lockedSlot = abstractContainerScreen.method_17577().field_7761.stream().filter(slot -> slot.field_7871 instanceof class_1661 && slot.method_34266() == slotId.intValue()).findFirst();
            if (lockedSlot.isEmpty()) continue;
            this.renderLockedSlot(event.getGuiGraphics(), abstractContainerScreen, lockedSlot.get());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInventoryClickEvent(ContainerClickEvent event) {
        class_465 abstractContainerScreen;
        block10: {
            block9: {
                class_437 class_4372 = McUtils.mc().field_1755;
                if (!(class_4372 instanceof class_465)) break block9;
                abstractContainerScreen = (class_465)class_4372;
                if (!(Models.Container.getCurrentContainer() instanceof FullscreenContainerProperty)) break block10;
            }
            return;
        }
        if (!((Boolean)this.blockAllActionsOnLockedItems.get()).booleanValue() && event.getClickType() != class_1713.field_7795) {
            return;
        }
        Optional<class_1735> slotOptional = abstractContainerScreen.method_17577().field_7761.stream().filter(slot -> slot.field_7871 instanceof class_1661 && slot.field_7874 == event.getSlotNum()).findFirst();
        if (slotOptional.isEmpty()) {
            return;
        }
        if (event.getMouseButton() == 1) {
            if (((Boolean)this.allowClickOnEmeraldPouchInBlockingMode.get()).booleanValue() && Models.Emerald.isEmeraldPouch(slotOptional.get().method_7677())) {
                return;
            }
            if (((Boolean)this.allowClickOnMultiHealthPotionsInBlockingMode.get()).booleanValue() && Models.Item.asWynnItem(slotOptional.get().method_7677(), MultiHealthPotionItem.class).isPresent()) {
                return;
            }
        }
        if (((Set)((Map)this.classSlotLockMap.get()).getOrDefault(Models.Character.getId(), new TreeSet())).contains(slotOptional.get().method_34266())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDrop(DropHeldItemEvent event) {
        class_1799 selected = McUtils.inventory().method_7391();
        Optional<class_1735> heldItemSlot = McUtils.inventoryMenu().field_7761.stream().filter(slot -> slot.method_7677() == selected).findFirst();
        if (heldItemSlot.isEmpty()) {
            return;
        }
        if (((Set)((Map)this.classSlotLockMap.get()).getOrDefault(Models.Character.getId(), new TreeSet())).contains(heldItemSlot.get().method_34266())) {
            event.setCanceled(true);
        }
    }

    private void renderLockedSlot(class_332 guiGraphics, class_465<?> containerScreen, class_1735 lockedSlot) {
        BufferedRenderUtils.drawTexturedRect(guiGraphics.method_51448(), (class_4597)guiGraphics.field_44658, Texture.ITEM_LOCK.resource(), containerScreen.field_2776 + lockedSlot.field_7873 + 12, containerScreen.field_2800 + lockedSlot.field_7872 - 4, 399.0f, 8.0f, 8.0f, Texture.ITEM_LOCK.width() / 2, Texture.ITEM_LOCK.height() / 2);
    }

    private void tryChangeLockStateOnHoveredSlot(class_1735 hoveredSlot) {
        if (hoveredSlot == null || !(hoveredSlot.field_7871 instanceof class_1661)) {
            return;
        }
        ((Map)this.classSlotLockMap.get()).putIfAbsent(Models.Character.getId(), new TreeSet());
        Set classSet = (Set)((Map)this.classSlotLockMap.get()).get(Models.Character.getId());
        if (classSet.contains(hoveredSlot.method_34266())) {
            classSet.remove(hoveredSlot.method_34266());
        } else {
            classSet.add(hoveredSlot.method_34266());
        }
        this.classSlotLockMap.touched();
    }
}

