/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.map;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.mc.event.PlayerAttackEvent;
import com.wynntils.mc.event.PlayerInteractEvent;
import com.wynntils.mc.event.ScreenOpenedEvent;
import com.wynntils.models.containers.containers.reward.LootChestContainer;
import com.wynntils.models.containers.type.LootChestTier;
import com.wynntils.screens.maps.MainMapScreen;
import com.wynntils.screens.maps.PoiCreationScreen;
import com.wynntils.services.map.pois.CustomPoi;
import com.wynntils.services.mapdata.providers.builtin.WaypointsProvider;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.type.HealthTexture;
import com.wynntils.utils.render.type.PointerType;
import com.wynntils.utils.render.type.TextShadow;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.MAP)
public class MainMapFeature
extends Feature {
    @Persisted
    public final HiddenConfig<List<CustomPoi>> customPois = new HiddenConfig(new ArrayList());
    @Persisted
    public final Config<Float> poiFadeAdjustment = new Config<Float>(Float.valueOf(0.4f));
    @Persisted
    public final Config<Float> combatPoiMinZoom = new Config<Float>(Float.valueOf(0.166f));
    @Persisted
    public final Config<Float> cavePoiMinZoom = new Config<Float>(Float.valueOf(0.28f));
    @Persisted
    public final Config<Float> servicePoiMinZoom = new Config<Float>(Float.valueOf(0.8f));
    @Persisted
    public final Config<Float> fastTravelPoiMinZoom = new Config<Float>(Float.valueOf(0.166f));
    @Persisted
    public final Config<Float> customPoiMinZoom = new Config<Float>(Float.valueOf(0.28f));
    @Persisted
    public final Config<Float> lootChestTier1PoiMinZoom = new Config<Float>(Float.valueOf(0.8f));
    @Persisted
    public final Config<Float> lootChestTier2PoiMinZoom = new Config<Float>(Float.valueOf(0.8f));
    @Persisted
    public final Config<Float> lootChestTier3PoiMinZoom = new Config<Float>(Float.valueOf(0.28f));
    @Persisted
    public final Config<Float> lootChestTier4PoiMinZoom = new Config<Float>(Float.valueOf(0.28f));
    @Persisted
    public final Config<PointerType> pointerType = new Config<PointerType>(PointerType.ARROW);
    @Persisted
    public final Config<CustomColor> pointerColor = new Config<CustomColor>(new CustomColor(1.0f, 1.0f, 1.0f, 1.0f));
    @Persisted
    public final Config<Float> playerPointerScale = new Config<Float>(Float.valueOf(1.5f));
    @Persisted
    public final Config<Float> poiScale = new Config<Float>(Float.valueOf(1.0f));
    @Persisted
    public final Config<Boolean> centerWhenUnmapped = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> autoWaypointChests = new Config<Boolean>(true);
    @Persisted
    private final Config<LootChestTier> minTierForAutoWaypoint = new Config<LootChestTier>(LootChestTier.TIER_3);
    @Persisted
    public final Config<Boolean> renderRemoteFriendPlayers = new Config<Boolean>(true);
    @Persisted
    public final Config<Boolean> renderRemotePartyPlayers = new Config<Boolean>(true);
    @Persisted
    public final Config<Boolean> renderRemoteGuildPlayers = new Config<Boolean>(true);
    @Persisted
    public final Config<HealthTexture> remotePlayerHealthTexture = new Config<HealthTexture>(HealthTexture.A);
    @Persisted
    public final Config<TextShadow> remotePlayerNameShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    public final Config<Boolean> holdGuildMapOpen = new Config<Boolean>(true);
    private class_2338 lastChestPos;
    @RegisterKeyBind
    public final KeyBind openMapKeybind = new KeyBind("Open Main Map", 77, false, this::openMainMap);
    @RegisterKeyBind
    public final KeyBind newWaypointKeybind = new KeyBind("New Waypoint", 66, true, this::openWaypointSetup);

    private void openMainMap() {
        class_437 class_4372 = McUtils.mc().field_1755;
        if (class_4372 instanceof MainMapScreen) {
            MainMapScreen mainMapScreen = (MainMapScreen)class_4372;
            mainMapScreen.setHoldingMapKey(true);
            return;
        }
        McUtils.mc().method_1507(MainMapScreen.create());
    }

    private void openWaypointSetup() {
        Location location = new Location(McUtils.player().method_31477(), McUtils.player().method_31478(), McUtils.player().method_31479());
        McUtils.mc().method_1507(PoiCreationScreen.create(null, location));
    }

    @SubscribeEvent
    public void onLeftClick(PlayerAttackEvent event) {
        if (!((Boolean)this.autoWaypointChests.get()).booleanValue()) {
            return;
        }
        this.handleEntity(event.getTarget());
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.InteractAt event) {
        if (!((Boolean)this.autoWaypointChests.get()).booleanValue()) {
            return;
        }
        this.handleEntity(event.getEntityHitResult().method_17782());
    }

    @SubscribeEvent
    public void onScreenOpened(ScreenOpenedEvent.Post event) {
        if (!((Boolean)this.autoWaypointChests.get()).booleanValue()) {
            return;
        }
        if (this.lastChestPos == null) {
            return;
        }
        if (!(event.getScreen() instanceof class_476)) {
            return;
        }
        if (!(Models.Container.getCurrentContainer() instanceof LootChestContainer)) {
            this.lastChestPos = null;
            return;
        }
        LootChestTier chestType = Models.LootChest.getChestType(event.getScreen());
        if (chestType == null) {
            return;
        }
        if (chestType.ordinal() < ((LootChestTier)((Object)this.minTierForAutoWaypoint.get())).ordinal()) {
            this.lastChestPos = null;
            return;
        }
        PoiLocation location = new PoiLocation(this.lastChestPos.method_10263(), this.lastChestPos.method_10264(), this.lastChestPos.method_10260());
        CustomPoi newPoi = new CustomPoi(location, chestType.getWaypointName(), CommonColors.WHITE, chestType.getWaypointTexture(), CustomPoi.Visibility.DEFAULT);
        if (((List)this.customPois.get()).stream().noneMatch(customPoi -> customPoi.equals(newPoi))) {
            ((List)this.customPois.get()).add(newPoi);
            Managers.Notification.queueMessage((class_2561)class_2561.method_43470((String)("Added new waypoint for " + chestType.getWaypointName())).method_27692(class_124.field_1075));
            this.customPois.touched();
            this.updateWaypoints();
        }
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        if (config == this.customPois) {
            this.updateWaypoints();
        }
    }

    public void updateWaypoints() {
        WaypointsProvider.resetFeatures();
        ((List)this.customPois.get()).forEach(WaypointsProvider::registerFeature);
    }

    private void handleEntity(class_1297 entity) {
        if (entity != null && entity.method_5864() == class_1299.field_42623) {
            this.lastChestPos = entity.method_24515();
        }
    }
}

