/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.trademarket;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.models.account.AccountModel;
import com.wynntils.models.containers.containers.trademarket.TradeMarketSellContainer;
import com.wynntils.models.trademarket.event.TradeMarketChatInputEvent;
import com.wynntils.models.trademarket.event.TradeMarketSellDialogueUpdatedEvent;
import com.wynntils.models.trademarket.type.TradeMarketPriceCheckInfo;
import com.wynntils.models.trademarket.type.TradeMarketState;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.TRADEMARKET)
public class TradeMarketPriceMatchFeature
extends Feature {
    @Persisted
    private final Config<Integer> undercutBy = new Config<Integer>(0);
    private boolean sendPriceMessage = false;
    private long priceToSend = 0L;

    @SubscribeEvent
    public void onSellDialogueUpdated(TradeMarketSellDialogueUpdatedEvent e) {
        class_437 class_4372 = McUtils.mc().field_1755;
        if (!(class_4372 instanceof class_476)) {
            return;
        }
        class_476 containerScreen = (class_476)class_4372;
        if (!(Models.Container.getCurrentContainer() instanceof TradeMarketSellContainer)) {
            return;
        }
        this.removePriceButtons(containerScreen);
        this.addPriceButtons(containerScreen);
    }

    @SubscribeEvent
    public void onTradeMarketChatInput(TradeMarketChatInputEvent e) {
        if (e.getState() != TradeMarketState.PRICE_CHAT_INPUT) {
            return;
        }
        if (!this.sendPriceMessage) {
            return;
        }
        WynntilsMod.info("Trying to set trade market price to " + this.priceToSend);
        e.setResponse(String.valueOf(this.priceToSend));
        e.cancelChat();
        this.sendPriceMessage = false;
    }

    private void addPriceButtons(class_476 containerScreen) {
        TradeMarketPriceCheckInfo priceCheckInfo = Models.TradeMarket.getPriceCheckInfo();
        int rightPos = containerScreen.field_2776 + containerScreen.field_2792 + 1;
        if (priceCheckInfo.bid() != -1) {
            int taxedBid = priceCheckInfo.bid();
            int untaxedBid = Models.Emerald.getWithoutTax(taxedBid);
            class_5250 buttonTooltip = class_2561.method_43471((String)"feature.wynntils.tradeMarketPriceMatch.highestBuyOfferMatchesTooltip").method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43471((String)"feature.wynntils.tradeMarketPriceMatch.recommendedPrice").method_27692(class_124.field_1076)).method_10852((class_2561)this.getPriceComponent(priceCheckInfo.recommendedPrice())).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"feature.wynntils.tradeMarketPriceMatch.youReceive").method_27692(class_124.field_1060)).method_10852((class_2561)this.getPriceComponent(untaxedBid)).method_10852((class_2561)(Models.Account.isSilverbullSubscriber() ? AccountModel.SILVERBULL_STAR : class_2561.method_43473())).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"feature.wynntils.tradeMarketPriceMatch.totalPrice").method_27692(class_124.field_1065)).method_10852((class_2561)this.getPriceComponent(taxedBid));
            PriceButton priceButton = new PriceButton(rightPos, containerScreen.field_2800 + 30, untaxedBid, (class_2561)class_2561.method_43471((String)"feature.wynntils.tradeMarketPriceMatch.highestBuyOffer"), (class_2561)buttonTooltip);
            containerScreen.method_37063((class_364)priceButton);
        }
        if (priceCheckInfo.ask() != -1) {
            int lowestAsk = priceCheckInfo.ask();
            int taxedBid = lowestAsk <= (Integer)this.undercutBy.get() ? 1 : lowestAsk - (Integer)this.undercutBy.get();
            int untaxedBid = Models.Emerald.getWithoutTax(taxedBid);
            class_5250 buttonTooltip = (Integer)this.undercutBy.get() == 0 ? class_2561.method_43471((String)"feature.wynntils.tradeMarketPriceMatch.lowestSellOfferMatchesTooltip") : class_2561.method_43469((String)"feature.wynntils.tradeMarketPriceMatch.lowestSellOfferUndercutTooltip", (Object[])new Object[]{this.undercutBy.get()});
            buttonTooltip.method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43471((String)"feature.wynntils.tradeMarketPriceMatch.recommendedPrice").method_27692(class_124.field_1076)).method_10852((class_2561)this.getPriceComponent(priceCheckInfo.recommendedPrice())).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"feature.wynntils.tradeMarketPriceMatch.youReceive").method_27692(class_124.field_1060)).method_10852((class_2561)this.getPriceComponent(untaxedBid)).method_10852((class_2561)(Models.Account.isSilverbullSubscriber() ? AccountModel.SILVERBULL_STAR : class_2561.method_43473())).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"feature.wynntils.tradeMarketPriceMatch.totalPrice").method_27692(class_124.field_1065)).method_10852((class_2561)this.getPriceComponent(taxedBid));
            PriceButton priceButton = new PriceButton(rightPos, containerScreen.field_2800 + 51, untaxedBid, (class_2561)class_2561.method_43471((String)"feature.wynntils.tradeMarketPriceMatch.lowestSellOffer"), (class_2561)buttonTooltip);
            containerScreen.method_37063((class_364)priceButton);
        }
    }

    private class_5250 getPriceComponent(int price) {
        return class_2561.method_43470((String)Models.Emerald.getEmeraldCountString(price, false)).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)(" (" + Models.Emerald.getFormattedString(price, false) + ")")).method_27692(class_124.field_1080));
    }

    private void removePriceButtons(class_476 containerScreen) {
        containerScreen.field_22786.stream().filter(child -> child instanceof PriceButton).toList().forEach(arg_0 -> ((class_476)containerScreen).method_37066(arg_0));
    }

    private final class PriceButton
    extends WynntilsButton {
        private static final int BUTTON_WIDTH = 100;
        private static final int BUTTON_HEIGHT = 20;
        private final int price;

        private PriceButton(int x, int y, int priceNoTax, class_2561 name, class_2561 hoverText) {
            super(x, y, 100, 20, name);
            this.price = priceNoTax;
            this.method_47400(class_7919.method_47407((class_2561)hoverText));
        }

        public void method_25306() {
            TradeMarketPriceMatchFeature.this.priceToSend = this.price;
            TradeMarketPriceMatchFeature.this.sendPriceMessage = true;
            ContainerUtils.clickOnSlot(28, McUtils.containerMenu().field_7763, 0, (List<class_1799>)McUtils.containerMenu().method_7602());
        }
    }
}

