/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.mod.TickSchedulerManager;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.mc.event.LoadingProgressEvent;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.mc.event.ScreenOpenedEvent;
import com.wynntils.mc.event.ServerResourcePackEvent;
import com.wynntils.mc.event.SubtitleSetTextEvent;
import com.wynntils.mc.event.TickAlwaysEvent;
import com.wynntils.mc.event.TitleSetTextEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.screens.loading.LoadingScreen;
import com.wynntils.utils.mc.McUtils;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_2588;
import net.minecraft.class_412;
import net.minecraft.class_419;
import net.minecraft.class_434;
import net.minecraft.class_435;
import net.minecraft.class_437;
import net.minecraft.class_7417;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UI)
public class CustomLoadingScreenFeature
extends Feature {
    private static final String IGNORED_TITLE = "\ue000\ue001\ue000";
    private static final Pattern SERVER_SWITCH_PATTERN = Pattern.compile("\u00a77Saving your player data before switching to \u00a7f(.*)\u00a77...");
    private LoadingScreen loadingScreen;
    private class_437 replacedScreen;
    private TickSchedulerManager.ScheduledTask delayedRemoval;
    private boolean allowClosing;

    @SubscribeEvent
    public void onTickAlways(TickAlwaysEvent e) {
        if (this.replacedScreen != null) {
            this.replacedScreen.method_25393();
        }
    }

    @SubscribeEvent
    public void onChatMessageReceived(ChatMessageEvent.Match e) {
        if (e.getMessage().matches(SERVER_SWITCH_PATTERN)) {
            this.createCustomScreen();
            this.loadingScreen.setMessage(class_1074.method_4662((String)"feature.wynntils.customLoadingScreen.switchingServer", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onScreenClosed(ScreenClosedEvent.Pre event) {
        if (this.allowClosing) {
            return;
        }
        if (this.isCustomScreenVisible()) {
            event.setCanceled(true);
        }
        if (this.replacedScreen != null) {
            this.replacedScreen.method_25432();
            this.replacedScreen = null;
        }
        if (McUtils.mc().field_1687 == null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onScreenOpened(ScreenOpenedEvent.Pre event) {
        class_2588 tc;
        class_7417 class_74172;
        class_437 screen = event.getScreen();
        if (screen instanceof LoadingScreen) {
            return;
        }
        if (this.replacedScreen != null) {
            this.replacedScreen.method_25432();
            this.replacedScreen = null;
        }
        String messageUpdate = null;
        if (screen instanceof class_435) {
            class_435 ps = (class_435)screen;
            messageUpdate = "feature.wynntils.customLoadingScreen.working";
        }
        if (screen instanceof class_412) {
            class_412 cs = (class_412)screen;
            class_74172 = cs.field_2413.method_10851();
            if (class_74172 instanceof class_2588 && (tc = (class_2588)class_74172).method_11022().equals("connect.transferring")) {
                messageUpdate = "feature.wynntils.customLoadingScreen.transferConnecting";
            }
        }
        if (screen instanceof class_419) {
            class_419 ds = (class_419)screen;
            class_74172 = ds.field_52131.comp_2853().method_10851();
            if (class_74172 instanceof class_2588 && (tc = (class_2588)class_74172).method_11022().equals("disconnect.transfer")) {
                messageUpdate = "feature.wynntils.customLoadingScreen.transferRequest";
            }
        }
        if (screen instanceof class_434) {
            messageUpdate = "feature.wynntils.customLoadingScreen.receivingTerrain";
        }
        if (!this.isCustomScreenVisible()) {
            if (!Managers.Connection.onServer()) {
                return;
            }
            if (messageUpdate == null) {
                return;
            }
            this.createCustomScreen();
        }
        if (messageUpdate != null) {
            this.loadingScreen.setMessage(class_1074.method_4662((String)messageUpdate, (Object[])new Object[0]));
        }
        this.replacedScreen = screen;
        screen.method_25423(McUtils.mc(), 1, 1);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onLoadingProgress(LoadingProgressEvent event) {
        if (!this.isCustomScreenVisible()) {
            return;
        }
        this.loadingScreen.setMessage(event.getMessage());
    }

    @SubscribeEvent
    public void onResourcePack(ServerResourcePackEvent.Load e) {
        if (!this.isCustomScreenVisible()) {
            return;
        }
        this.loadingScreen.setMessage(class_1074.method_4662((String)"feature.wynntils.customLoadingScreen.resourcePack", (Object[])new Object[0]));
    }

    @SubscribeEvent
    public void onTitleSetText(TitleSetTextEvent e) {
        if (!this.isCustomScreenVisible()) {
            return;
        }
        if (e.getComponent().getString().equals(IGNORED_TITLE)) {
            return;
        }
        this.loadingScreen.setStageTitle(e.getComponent().getString());
    }

    @SubscribeEvent
    public void onSubtitleSetText(SubtitleSetTextEvent e) {
        if (!this.isCustomScreenVisible()) {
            return;
        }
        this.loadingScreen.setSubtitle(e.getComponent().getString());
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        switch (event.getNewState()) {
            case CONNECTING: {
                this.createCustomScreen();
                this.loadingScreen.setMessage(class_1074.method_4662((String)"feature.wynntils.customLoadingScreen.connecting", (Object[])new Object[0]));
                break;
            }
            case INTERIM: {
                if (!this.isCustomScreenVisible()) {
                    this.createCustomScreen();
                }
                this.cancelDelayedRemoval();
                this.loadingScreen.setMessage(class_1074.method_4662((String)"feature.wynntils.customLoadingScreen.joiningWorld", (Object[])new Object[0]));
                break;
            }
            case HUB: {
                if (!this.isCustomScreenVisible()) {
                    return;
                }
                this.delayedRemoval = Managers.TickScheduler.scheduleLater(this::removeCustomScreen, 20);
                break;
            }
            case WORLD: 
            case NOT_CONNECTED: 
            case CHARACTER_SELECTION: {
                if (!this.isCustomScreenVisible()) {
                    return;
                }
                this.cancelDelayedRemoval();
                this.delayedRemoval = Managers.TickScheduler.scheduleLater(this::removeCustomScreen, 20);
            }
        }
    }

    private boolean isCustomScreenVisible() {
        return this.loadingScreen != null;
    }

    private void createCustomScreen() {
        this.loadingScreen = LoadingScreen.create(this::onLoadingScreenClosed);
        this.allowClosing = false;
        McUtils.mc().method_1507((class_437)this.loadingScreen);
    }

    private void removeCustomScreen() {
        this.delayedRemoval = null;
        this.loadingScreen = null;
        if (McUtils.mc().field_1755 == null) {
            WynntilsMod.error("The custom LoadingScreen has disappeared");
        } else {
            McUtils.mc().method_1507(null);
        }
    }

    private void onLoadingScreenClosed() {
        this.allowClosing = true;
        if (this.replacedScreen != null) {
            this.replacedScreen.method_25419();
        }
        this.delayedRemoval = null;
        this.loadingScreen = null;
    }

    private void cancelDelayedRemoval() {
        if (this.delayedRemoval != null) {
            Managers.TickScheduler.cancel(this.delayedRemoval);
            this.delayedRemoval = null;
        }
    }
}

