/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.utilities;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.chat.type.RecipientType;
import com.wynntils.models.npcdialogue.event.NpcDialogueProcessingEvent;
import com.wynntils.services.translation.TranslationService;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.UTILITIES)
public class TranslationFeature
extends Feature {
    @Persisted
    private final Config<String> languageName = new Config<String>("");
    @Persisted
    public final Config<Boolean> translateTrackedQuest = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> translateNpc = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> translateInfo = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> translatePlayerChat = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> keepOriginal = new Config<Boolean>(true);
    @Persisted
    private final Config<TranslationService.TranslationServices> translationService = new Config<TranslationService.TranslationServices>(TranslationService.TranslationServices.GOOGLEAPI);

    @SubscribeEvent
    public void onChat(ChatMessageEvent.Match e) {
        if (((String)this.languageName.get()).isEmpty()) {
            return;
        }
        if (e.getRecipientType() != RecipientType.INFO && !((Boolean)this.translatePlayerChat.get()).booleanValue()) {
            return;
        }
        if (e.getRecipientType() == RecipientType.INFO && !((Boolean)this.translateInfo.get()).booleanValue()) {
            return;
        }
        StyledText originalMessage = e.getMessage();
        String codedString = this.wrapCoding(originalMessage);
        Services.Translation.getTranslator((TranslationService.TranslationServices)((Object)this.translationService.get())).translate(List.of(codedString), (String)this.languageName.get(), translatedMsgList -> {
            StyledText messageToSend;
            if (!translatedMsgList.isEmpty()) {
                String result = (String)translatedMsgList.getFirst();
                messageToSend = this.unwrapCoding(result, originalMessage);
            } else {
                if (((Boolean)this.keepOriginal.get()).booleanValue()) {
                    return;
                }
                messageToSend = originalMessage;
            }
            McUtils.mc().method_18859(() -> McUtils.sendMessageToClient((class_2561)messageToSend.getComponent()));
        });
        if (!((Boolean)this.keepOriginal.get()).booleanValue()) {
            e.cancelChat();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onNpcDialogue(NpcDialogueProcessingEvent.Pre event) {
        if (!((Boolean)this.translateNpc.get()).booleanValue()) {
            return;
        }
        if (((String)this.languageName.get()).isEmpty()) {
            return;
        }
        event.addProcessingStep(future -> future.thenCompose(styledTexts -> {
            if (styledTexts.isEmpty()) {
                return CompletableFuture.completedFuture(styledTexts);
            }
            CompletableFuture translationFuture = new CompletableFuture();
            CompletableFuture.runAsync(() -> {
                try {
                    Services.Translation.getTranslator((TranslationService.TranslationServices)((Object)((Object)((Object)((Object)this.translationService.get()))))).translate(styledTexts.stream().map(this::wrapCoding).toList(), (String)this.languageName.get(), translatedMsgList -> {
                        ArrayList<StyledText> translatedComponents = new ArrayList<StyledText>();
                        if (((Boolean)this.keepOriginal.get()).booleanValue()) {
                            translatedComponents.addAll((Collection<StyledText>)styledTexts);
                        }
                        for (int i = 0; i < translatedMsgList.size(); ++i) {
                            String result = (String)translatedMsgList.get(i);
                            StyledText originalText = (StyledText)styledTexts.get(i);
                            StyledText messageToSend = this.unwrapCoding(result, originalText);
                            translatedComponents.add(messageToSend);
                        }
                        translationFuture.complete(translatedComponents);
                    });
                }
                catch (Exception e) {
                    WynntilsMod.error("Failed to translate NPC dialogue.", e);
                    translationFuture.complete(styledTexts);
                }
            });
            return translationFuture;
        }));
    }

    private StyledText unwrapCoding(String codedTranslatedString, StyledText originalText) {
        return StyledText.fromModifiedString(codedTranslatedString.replaceAll("\\{ ?\u00a7 ?([0-9a-fklmnor]) ?\\}", "\u00a7$1").replaceAll("\\[ ?\u00a7 ?([0-9]+) ?\\]", "\u00a7[$1]").replaceAll("\\< ?\u00a7 ?([0-9]+) ?\\>", "\u00a7<$1>").replace('\u00c1', 'A').replace('\u00c0', 'A'), originalText);
    }

    private String wrapCoding(StyledText origCoded) {
        return origCoded.getString(StyleType.INCLUDE_EVENTS).replaceAll("(\u00a7[0-9a-fklmnor])", "{$1}").replaceAll("\u00a7\\[([0-9]+)\\]", "[\u00a7$1]").replaceAll("\u00a7<([0-9]+)>", "<\u00a7$1>");
    }
}

