/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.hades.protocol.packets.client;

import com.wynntils.hades.protocol.interfaces.HadesPacket;
import com.wynntils.hades.protocol.interfaces.adapters.IHadesServerAdapter;
import com.wynntils.hades.utils.HadesBuffer;

public class HCPacketUpdateStatus
implements HadesPacket<IHadesServerAdapter> {
    float x;
    float y;
    float z;
    int health;
    int mana;
    int maxHealth;
    int maxMana;
    String helmet;
    String chestplate;
    String leggings;
    String boots;
    String ringOne;
    String ringTwo;
    String bracelet;
    String necklace;
    String heldItem;

    public HCPacketUpdateStatus() {
    }

    public HCPacketUpdateStatus(float x, float y, float z, int health, int maxHealth, int mana, int maxMana) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.health = health;
        this.maxHealth = maxHealth;
        this.mana = mana;
        this.maxMana = maxMana;
        this.helmet = "";
        this.chestplate = "";
        this.leggings = "";
        this.boots = "";
        this.ringOne = "";
        this.ringTwo = "";
        this.bracelet = "";
        this.necklace = "";
        this.heldItem = "";
    }

    public HCPacketUpdateStatus(float x, float y, float z, int health, int maxHealth, int mana, int maxMana, String helmet, String chestplate, String leggings, String boots, String ringOne, String ringTwo, String bracelet, String necklace, String heldItem) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.health = health;
        this.maxHealth = maxHealth;
        this.mana = mana;
        this.maxMana = maxMana;
        this.helmet = helmet;
        this.chestplate = chestplate;
        this.leggings = leggings;
        this.boots = boots;
        this.ringOne = ringOne;
        this.ringTwo = ringTwo;
        this.bracelet = bracelet;
        this.necklace = necklace;
        this.heldItem = heldItem;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public int getHealth() {
        return this.health;
    }

    public int getMana() {
        return this.mana;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public int getMaxMana() {
        return this.maxMana;
    }

    public String getHelmet() {
        return this.helmet;
    }

    public String getChestplate() {
        return this.chestplate;
    }

    public String getLeggings() {
        return this.leggings;
    }

    public String getBoots() {
        return this.boots;
    }

    public String getRingOne() {
        return this.ringOne;
    }

    public String getRingTwo() {
        return this.ringTwo;
    }

    public String getBracelet() {
        return this.bracelet;
    }

    public String getNecklace() {
        return this.necklace;
    }

    public String getHeldItem() {
        return this.heldItem;
    }

    @Override
    public void readData(HadesBuffer buffer) {
        this.x = buffer.readFloat();
        this.y = buffer.readFloat();
        this.z = buffer.readFloat();
        this.health = buffer.readInt();
        this.maxHealth = buffer.readInt();
        this.mana = buffer.readInt();
        this.maxMana = buffer.readInt();
        if (buffer.readableBytes() > 0) {
            this.helmet = buffer.readString();
            this.chestplate = buffer.readString();
            this.leggings = buffer.readString();
            this.boots = buffer.readString();
            this.ringOne = buffer.readString();
            this.ringTwo = buffer.readString();
            this.bracelet = buffer.readString();
            this.necklace = buffer.readString();
            this.heldItem = buffer.readString();
        } else {
            this.helmet = "";
            this.chestplate = "";
            this.leggings = "";
            this.boots = "";
            this.ringOne = "";
            this.ringTwo = "";
            this.bracelet = "";
            this.necklace = "";
            this.heldItem = "";
        }
    }

    @Override
    public void writeData(HadesBuffer buffer) {
        buffer.writeFloat(this.x);
        buffer.writeFloat(this.y);
        buffer.writeFloat(this.z);
        buffer.writeInt(this.health);
        buffer.writeInt(this.maxHealth);
        buffer.writeInt(this.mana);
        buffer.writeInt(this.maxMana);
        if (this.helmet.isEmpty() && this.chestplate.isEmpty() && this.leggings.isEmpty() && this.boots.isEmpty() && this.ringOne.isEmpty() && this.ringTwo.isEmpty() && this.bracelet.isEmpty() && this.necklace.isEmpty() && this.heldItem.isEmpty()) {
            return;
        }
        buffer.writeString(this.helmet);
        buffer.writeString(this.chestplate);
        buffer.writeString(this.leggings);
        buffer.writeString(this.boots);
        buffer.writeString(this.ringOne);
        buffer.writeString(this.ringTwo);
        buffer.writeString(this.bracelet);
        buffer.writeString(this.necklace);
        buffer.writeString(this.heldItem);
    }

    @Override
    public void process(IHadesServerAdapter handler) {
        handler.handleUpdateStatus(this);
    }
}

