/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.tooltip.type.TooltipIdentificationDecorator;
import com.wynntils.handlers.tooltip.type.TooltipStyle;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.gear.type.ItemWeightSource;
import com.wynntils.models.stats.type.StatListOrdering;
import com.wynntils.models.wynnitem.parsing.WynnItemParser;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public abstract class TooltipBuilder {
    private static final TooltipStyle DEFAULT_TOOLTIP_STYLE = new TooltipStyle(StatListOrdering.WYNNCRAFT, false, false, true, ItemWeightSource.NONE, true);
    private final List<class_2561> header;
    private final List<class_2561> footer;
    private final String source;
    private ClassType cachedCurrentClass;
    private TooltipStyle cachedStyle;
    private TooltipIdentificationDecorator cachedDecorator;
    private List<class_2561> identificationsCache;
    private List<class_2561> weightedHeaderCache;

    protected TooltipBuilder(List<class_2561> header, List<class_2561> footer, String source) {
        this.header = header;
        this.footer = footer;
        this.source = source;
    }

    public List<class_2561> getTooltipLines(ClassType currentClass) {
        return this.getTooltipLines(currentClass, DEFAULT_TOOLTIP_STYLE, null);
    }

    public List<class_2561> getTooltipLines(ClassType currentClass, TooltipStyle style, TooltipIdentificationDecorator decorator) {
        ArrayList<class_2561> tooltip;
        if (currentClass != this.cachedCurrentClass || !Objects.equals(this.cachedStyle, style) || !Objects.equals(this.cachedDecorator, decorator)) {
            List<class_2561> identifications = this.getIdentificationLines(currentClass, style, decorator);
            this.identificationsCache = identifications;
            this.cachedCurrentClass = currentClass;
            this.cachedStyle = style;
            this.cachedDecorator = decorator;
            List<class_2561> weightings = null;
            if (style.weightSource() != ItemWeightSource.NONE) {
                weightings = this.getWeightedHeaderLines(this.header, style);
            }
            this.weightedHeaderCache = weightings;
        }
        if (style.weightSource() != ItemWeightSource.NONE) {
            if (this.weightedHeaderCache == null) {
                this.weightedHeaderCache = this.getWeightedHeaderLines(this.header, style);
            }
            tooltip = new ArrayList<class_2561>(this.weightedHeaderCache);
        } else {
            tooltip = new ArrayList<class_2561>(this.header);
        }
        tooltip.addAll(this.identificationsCache);
        tooltip.addAll(this.footer);
        if (!this.source.isEmpty()) {
            tooltip.add(1, (class_2561)class_2561.method_43470((String)this.source).method_27692(class_124.field_1063).method_27692(class_124.field_1056));
        }
        return tooltip;
    }

    protected abstract List<class_2561> getWeightedHeaderLines(List<class_2561> var1, TooltipStyle var2);

    protected abstract List<class_2561> getIdentificationLines(ClassType var1, TooltipStyle var2, TooltipIdentificationDecorator var3);

    protected static Pair<List<class_2561>, List<class_2561>> extractHeaderAndFooter(List<class_2561> lore) {
        ArrayList<class_2561> header = new ArrayList<class_2561>();
        ArrayList<Object> footer = new ArrayList<Object>();
        boolean headerEnded = false;
        boolean footerStarted = false;
        boolean skillPointsStarted = false;
        boolean foundSkills = false;
        boolean foundIdentifications = false;
        for (class_2561 loreLine : lore) {
            StyledText codedLine = StyledText.fromComponent(loreLine).getNormalized();
            if (!footerStarted) {
                if (codedLine.matches(WynnItemParser.SET_BONUS_PATTERN)) {
                    headerEnded = true;
                    footerStarted = true;
                } else {
                    Matcher matcher = codedLine.getMatcher(WynnItemParser.IDENTIFICATION_STAT_PATTERN);
                    if (matcher.matches()) {
                        skillPointsStarted = false;
                        String statName = matcher.group(6);
                        if (Skill.isSkill(statName)) {
                            skillPointsStarted = true;
                            foundSkills = true;
                        } else {
                            foundIdentifications = true;
                        }
                        headerEnded = true;
                        continue;
                    }
                    if (skillPointsStarted) {
                        skillPointsStarted = false;
                        continue;
                    }
                }
            }
            if (!headerEnded) {
                header.add(loreLine);
                continue;
            }
            footerStarted = true;
            footer.add(loreLine);
        }
        if (foundSkills && !foundIdentifications) {
            footer.addFirst(class_2561.method_43470((String)""));
        }
        return Pair.of(header, footer);
    }
}

