/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.crafted;

import com.wynntils.handlers.tooltip.TooltipBuilder;
import com.wynntils.handlers.tooltip.impl.crafted.CraftedTooltipComponent;
import com.wynntils.handlers.tooltip.impl.crafted.CraftedTooltipIdentifications;
import com.wynntils.handlers.tooltip.type.TooltipIdentificationDecorator;
import com.wynntils.handlers.tooltip.type.TooltipStyle;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.items.properties.CraftedItemProperty;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.type.Pair;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public final class CraftedTooltipBuilder
extends TooltipBuilder {
    private final CraftedItemProperty craftedItem;

    private CraftedTooltipBuilder(CraftedItemProperty craftedItem, List<class_2561> header, List<class_2561> footer, String source) {
        super(header, footer, source);
        this.craftedItem = craftedItem;
    }

    private CraftedTooltipBuilder(CraftedItemProperty craftedItem, List<class_2561> header, List<class_2561> footer) {
        this(craftedItem, header, footer, "");
    }

    public static <T extends CraftedItemProperty> CraftedTooltipBuilder buildNewItem(T craftedItem, CraftedTooltipComponent<T> tooltipComponent, String source) {
        List<class_2561> header = tooltipComponent.buildHeaderTooltip(craftedItem);
        List<class_2561> footer = tooltipComponent.buildFooterTooltip(craftedItem);
        return new CraftedTooltipBuilder(craftedItem, header, footer, source);
    }

    public static CraftedTooltipBuilder fromParsedItemStack(class_1799 itemStack, CraftedItemProperty craftedItem) {
        List<class_2561> tooltips = LoreUtils.getTooltipLines(itemStack);
        Pair<List<class_2561>, List<class_2561>> splitLore = CraftedTooltipBuilder.extractHeaderAndFooter(tooltips);
        List<class_2561> header = splitLore.a();
        List<class_2561> footer = splitLore.b();
        return new CraftedTooltipBuilder(craftedItem, header, footer);
    }

    @Override
    protected List<class_2561> getWeightedHeaderLines(List<class_2561> originalHeader, TooltipStyle style) {
        return originalHeader;
    }

    @Override
    protected List<class_2561> getIdentificationLines(ClassType currentClass, TooltipStyle style, TooltipIdentificationDecorator decorator) {
        return CraftedTooltipIdentifications.buildTooltip(this.craftedItem, currentClass, style);
    }
}

