/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.crafted.components;

import com.wynntils.core.components.Models;
import com.wynntils.handlers.tooltip.impl.crafted.CraftedTooltipComponent;
import com.wynntils.models.activities.quests.QuestInfo;
import com.wynntils.models.activities.type.ActivityStatus;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.elements.type.Element;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.gear.type.GearRequirements;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.stats.type.DamageType;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class CraftedGearTooltipComponent
extends CraftedTooltipComponent<CraftedGearItem> {
    @Override
    public List<class_2561> buildHeaderTooltip(CraftedGearItem craftedItem) {
        int n;
        int health;
        ArrayList<class_2561> header = new ArrayList<class_2561>();
        header.add((class_2561)class_2561.method_43470((String)craftedItem.getName()).method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)(" [" + craftedItem.getEffectStrength() + "%]")).method_27692(class_124.field_1075)));
        if (craftedItem.getAttackSpeed().isPresent()) {
            header.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + craftedItem.getAttackSpeed().get().getName())));
        }
        header.add((class_2561)class_2561.method_43470((String)""));
        if (!craftedItem.getDamages().isEmpty()) {
            List<Pair<DamageType, RangedValue>> damages = craftedItem.getDamages();
            for (Pair<DamageType, RangedValue> damageStat : damages) {
                DamageType damageType = damageStat.key();
                String elementSymbol = damageType.getElement().isPresent() ? damageType.getElement().get().getSymbol() : damageType.getSymbol();
                class_5250 damage = class_2561.method_43473().method_27692(damageType.getColorCode()).method_10852((class_2561)class_2561.method_43470((String)elementSymbol).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")))).method_10852((class_2561)class_2561.method_43470((String)(" " + damageType.getDisplayName())));
                damage.method_10852((class_2561)class_2561.method_43470((String)("Damage: " + ((RangedValue)damageStat.value()).asString())).method_27692(damageType == DamageType.NEUTRAL ? damageType.getColorCode() : class_124.field_1080));
                header.add((class_2561)damage);
            }
            header.add((class_2561)class_2561.method_43470((String)""));
        }
        if ((health = craftedItem.getHealth()) != 0) {
            class_5250 healthComp = class_2561.method_43470((String)("\u2764 Health: " + StringUtils.toSignedString(health))).method_27692(class_124.field_1079);
            header.add((class_2561)healthComp);
        }
        if (!craftedItem.getDefences().isEmpty()) {
            List<Pair<Element, Integer>> defenses = craftedItem.getDefences();
            for (Pair pair : defenses) {
                Element element = (Element)((Object)pair.key());
                class_5250 defense = class_2561.method_43473().method_27692(element.getColorCode()).method_10852((class_2561)class_2561.method_43470((String)element.getSymbol()).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")))).method_10852((class_2561)class_2561.method_43470((String)(" " + element.getDisplayName())));
                defense.method_10852((class_2561)class_2561.method_43470((String)(" Defence: " + StringUtils.toSignedString((Integer)pair.value()))).method_27692(class_124.field_1080));
                header.add((class_2561)defense);
            }
        }
        if (health != 0 || !craftedItem.getDefences().isEmpty()) {
            header.add((class_2561)class_2561.method_43470((String)""));
        }
        int requirementsCount = 0;
        GearRequirements requirements = craftedItem.getRequirements();
        if (requirements.classType().isPresent()) {
            ClassType classType = requirements.classType().get();
            boolean fulfilled = Models.Character.getClassType() == classType;
            header.add((class_2561)this.buildRequirementLine("Class Req: " + classType.getFullName(), fulfilled));
            ++requirementsCount;
        }
        if (requirements.quest().isPresent()) {
            String string = requirements.quest().get();
            Optional<QuestInfo> quest = Models.Quest.getQuestFromName(string);
            boolean fulfilled = quest.isPresent() && quest.get().status() == ActivityStatus.COMPLETED;
            header.add((class_2561)this.buildRequirementLine("Quest Req: " + string, fulfilled));
            ++requirementsCount;
        }
        if ((n = requirements.level()) != 0) {
            boolean fulfilled = Models.CombatXp.getCombatLevel().current() >= n;
            header.add((class_2561)this.buildRequirementLine("Combat Lv. Min: " + n, fulfilled));
            ++requirementsCount;
        }
        if (!requirements.skills().isEmpty()) {
            for (Pair<Skill, Integer> skillRequirement : requirements.skills()) {
                header.add((class_2561)this.buildRequirementLine(skillRequirement.key().getDisplayName() + " Min: " + String.valueOf(skillRequirement.value()), false));
                ++requirementsCount;
            }
        }
        if (requirementsCount > 0) {
            header.add((class_2561)class_2561.method_43470((String)""));
        }
        return header;
    }

    @Override
    public List<class_2561> buildFooterTooltip(CraftedGearItem craftedItem) {
        ArrayList<class_2561> footer = new ArrayList<class_2561>();
        footer.add((class_2561)class_2561.method_43473());
        if (!craftedItem.getPowders().isEmpty()) {
            class_5250 powderLine = class_2561.method_43470((String)("[" + craftedItem.getPowders().size() + "/" + craftedItem.getPowderSlots() + "] Powder Slots ")).method_27692(class_124.field_1080);
            if (!craftedItem.getPowders().isEmpty()) {
                class_5250 powderList = class_2561.method_43470((String)"[");
                for (Powder p : craftedItem.getPowders()) {
                    String symbol = String.valueOf(p.getSymbol());
                    if (!powderList.method_10855().isEmpty()) {
                        powderList.method_10852((class_2561)class_2561.method_43473().method_27696(class_2583.field_24360.method_10977(p.getLightColor())).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)symbol).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")))));
                        continue;
                    }
                    powderList.method_10852((class_2561)class_2561.method_43470((String)symbol).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")).method_10977(p.getLightColor())));
                }
                powderList.method_10852((class_2561)class_2561.method_43470((String)"]"));
                powderLine.method_10852((class_2561)powderList);
            }
            footer.add((class_2561)powderLine);
        }
        footer.add((class_2561)class_2561.method_43470((String)("Crafted " + StringUtils.capitalizeFirst(craftedItem.getGearType().name().toLowerCase(Locale.ROOT)))).method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)(" [" + craftedItem.getDurability().current() + "/" + craftedItem.getDurability().max() + " Durability]")).method_27692(class_124.field_1063)));
        return footer;
    }
}

