/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.identifiable.components;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipComponent;
import com.wynntils.models.activities.quests.QuestInfo;
import com.wynntils.models.activities.type.ActivityStatus;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.elements.type.Element;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.GearInstance;
import com.wynntils.models.gear.type.GearMajorId;
import com.wynntils.models.gear.type.GearRequirements;
import com.wynntils.models.gear.type.GearRestrictions;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.stats.type.DamageType;
import com.wynntils.models.stats.type.ShinyStat;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.RenderedStringUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public final class GearTooltipComponent
extends IdentifiableTooltipComponent<GearInfo, GearInstance> {
    private static final int PIXEL_WIDTH = 150;

    @Override
    public List<class_2561> buildHeaderTooltip(GearInfo gearInfo, GearInstance gearInstance, boolean hideUnidentified) {
        int n;
        int health;
        ArrayList<class_2561> header = new ArrayList<class_2561>();
        String unidentifiedPrefix = gearInstance == null && !hideUnidentified ? "Unidentified " : "";
        class_5250 shinyPrefix = gearInstance != null && gearInstance.shinyStat().isPresent() ? class_2561.method_43470((String)"\u2b21 ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)"Shiny ").method_27692(gearInfo.tier().getChatFormatting())) : class_2561.method_43473();
        header.add((class_2561)class_2561.method_43473().method_27692(gearInfo.tier().getChatFormatting()).method_10852((class_2561)class_2561.method_43470((String)unidentifiedPrefix).method_10852((class_2561)shinyPrefix).method_10852((class_2561)class_2561.method_43470((String)gearInfo.name()))));
        if (gearInfo.fixedStats().attackSpeed().isPresent()) {
            header.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + gearInfo.fixedStats().attackSpeed().get().getName())));
        }
        header.add((class_2561)class_2561.method_43470((String)""));
        if (!gearInfo.fixedStats().damages().isEmpty()) {
            List<Pair<DamageType, RangedValue>> damages = gearInfo.fixedStats().damages();
            for (Pair<DamageType, RangedValue> damageStat : damages) {
                DamageType damageType = damageStat.key();
                String elementSymbol = damageType.getElement().isPresent() ? damageType.getElement().get().getSymbol() : damageType.getSymbol();
                class_5250 damage = class_2561.method_43473().method_27692(damageType.getColorCode()).method_10852((class_2561)class_2561.method_43470((String)elementSymbol).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")))).method_10852((class_2561)class_2561.method_43470((String)(" " + damageType.getDisplayName())));
                damage.method_10852((class_2561)class_2561.method_43470((String)("Damage: " + ((RangedValue)damageStat.value()).asString())).method_27692(damageType == DamageType.NEUTRAL ? damageType.getColorCode() : class_124.field_1080));
                header.add((class_2561)damage);
            }
            header.add((class_2561)class_2561.method_43470((String)""));
        }
        if ((health = gearInfo.fixedStats().healthBuff()) != 0) {
            class_5250 healthComp = class_2561.method_43470((String)("\u2764 Health: " + StringUtils.toSignedString(health))).method_27692(class_124.field_1079);
            header.add((class_2561)healthComp);
        }
        if (!gearInfo.fixedStats().defences().isEmpty()) {
            List<Pair<Element, Integer>> defenses = gearInfo.fixedStats().defences();
            for (Pair pair : defenses) {
                Element element = (Element)((Object)pair.key());
                class_5250 defense = class_2561.method_43473().method_27692(element.getColorCode()).method_10852((class_2561)class_2561.method_43470((String)element.getSymbol()).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")))).method_10852((class_2561)class_2561.method_43470((String)(" " + element.getDisplayName())));
                defense.method_10852((class_2561)class_2561.method_43470((String)(" Defence: " + StringUtils.toSignedString((Integer)pair.value()))).method_27692(class_124.field_1080));
                header.add((class_2561)defense);
            }
        }
        if (health != 0 || !gearInfo.fixedStats().defences().isEmpty()) {
            header.add((class_2561)class_2561.method_43470((String)""));
        }
        int requirementsCount = 0;
        GearRequirements requirements = gearInfo.requirements();
        if (requirements.classType().isPresent()) {
            ClassType classType = requirements.classType().get();
            boolean fulfilled = Models.Character.getClassType() == classType;
            header.add((class_2561)this.buildRequirementLine("Class Req: " + classType.getFullName(), fulfilled));
            ++requirementsCount;
        }
        if (requirements.quest().isPresent()) {
            String string = requirements.quest().get();
            Optional<QuestInfo> quest = Models.Quest.getQuestFromName(string);
            boolean fulfilled = quest.isPresent() && quest.get().status() == ActivityStatus.COMPLETED;
            header.add((class_2561)this.buildRequirementLine("Quest Req: " + string, fulfilled));
            ++requirementsCount;
        }
        if ((n = requirements.level()) != 0) {
            boolean fulfilled = Models.CombatXp.getCombatLevel().current() >= n;
            header.add((class_2561)this.buildRequirementLine("Combat Lv. Min: " + n, fulfilled));
            ++requirementsCount;
        }
        if (!requirements.skills().isEmpty()) {
            for (Pair<Skill, Integer> skillRequirement : requirements.skills()) {
                header.add((class_2561)this.buildRequirementLine(skillRequirement.key().getDisplayName() + " Min: " + String.valueOf(skillRequirement.value()), false));
                ++requirementsCount;
            }
        }
        if (requirementsCount > 0) {
            header.add((class_2561)class_2561.method_43470((String)""));
        }
        if (gearInstance != null && gearInstance.shinyStat().isPresent()) {
            ShinyStat shinyStat = gearInstance.shinyStat().get();
            if (shinyStat.shinyRerolls() == 0) {
                header.add((class_2561)class_2561.method_43470((String)("\u2b21 " + shinyStat.statType().displayName() + ": ")).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(shinyStat.value())).method_27692(class_124.field_1068)));
            } else {
                header.add((class_2561)class_2561.method_43470((String)("\u2b21 " + shinyStat.statType().displayName() + ": ")).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(shinyStat.value())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(" [" + shinyStat.shinyRerolls() + "]")).method_27692(class_124.field_1063)));
            }
            header.add((class_2561)class_2561.method_43470((String)""));
        }
        return header;
    }

    @Override
    public List<class_2561> buildFooterTooltip(GearInfo gearInfo, GearInstance gearInstance, boolean showItemType) {
        Optional<StyledText> lore;
        ArrayList<class_2561> footer = new ArrayList<class_2561>();
        if (gearInfo.fixedStats().majorIds().isPresent()) {
            GearMajorId majorId = gearInfo.fixedStats().majorIds().get();
            StyledText lore2 = StyledText.fromComponent((class_2561)class_2561.method_43473().method_27692(class_124.field_1062).method_10852((class_2561)majorId.lore().getComponent()));
            Stream.of(RenderedStringUtils.wrapTextBySize(lore2, 150)).forEach(c -> footer.add((class_2561)c.getComponent()));
        }
        footer.add((class_2561)class_2561.method_43470((String)""));
        if (gearInfo.powderSlots() > 0) {
            if (gearInstance == null) {
                footer.add((class_2561)class_2561.method_43470((String)("[" + gearInfo.powderSlots() + " Powder Slots]")).method_27692(class_124.field_1080));
            } else {
                class_5250 powderLine = class_2561.method_43470((String)("[" + gearInstance.powders().size() + "/" + gearInfo.powderSlots() + "] Powder Slots ")).method_27692(class_124.field_1080);
                if (!gearInstance.powders().isEmpty()) {
                    class_5250 powderList = class_2561.method_43470((String)"[");
                    for (Powder p : gearInstance.powders()) {
                        String symbol = String.valueOf(p.getSymbol());
                        if (!powderList.method_10855().isEmpty()) {
                            powderList.method_10852((class_2561)class_2561.method_43473().method_27696(class_2583.field_24360.method_10977(p.getLightColor())).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)symbol).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")))));
                            continue;
                        }
                        powderList.method_10852((class_2561)class_2561.method_43470((String)symbol).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")).method_10977(p.getLightColor())));
                    }
                    powderList.method_10852((class_2561)class_2561.method_43470((String)"]"));
                    powderLine.method_10852((class_2561)powderList);
                }
                footer.add((class_2561)powderLine);
            }
        }
        GearTier gearTier = gearInfo.tier();
        class_5250 itemTypeName = showItemType ? class_2561.method_43470((String)StringUtils.capitalizeFirst(gearInfo.type().name().toLowerCase(Locale.ROOT))) : class_2561.method_43470((String)"Item");
        class_5250 tier = class_2561.method_43470((String)gearTier.getName()).method_27692(gearTier.getChatFormatting()).method_27693(" ").method_10852((class_2561)itemTypeName);
        if (gearInstance != null && gearInstance.rerolls() > 1) {
            tier.method_27693(" [" + gearInstance.rerolls() + "]");
        }
        footer.add((class_2561)tier);
        if (gearInfo.metaInfo().restrictions() != GearRestrictions.NONE) {
            footer.add((class_2561)class_2561.method_43470((String)StringUtils.capitalizeFirst(gearInfo.metaInfo().restrictions().getDescription())).method_27692(class_124.field_1061));
        }
        if ((lore = gearInfo.metaInfo().lore()).isPresent()) {
            Stream.of(RenderedStringUtils.wrapTextBySize(lore.get(), 150)).forEach(c -> footer.add((class_2561)c.getComponent().method_27692(class_124.field_1063)));
        }
        return footer;
    }
}

