/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilities;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.SubtitleSetTextEvent;
import com.wynntils.mc.event.TitleSetTextEvent;
import com.wynntils.models.abilities.event.ShamanMaskTitlePacketEvent;
import com.wynntils.models.abilities.type.ShamanMaskType;
import com.wynntils.models.character.event.CharacterDeathEvent;
import com.wynntils.models.statuseffects.event.StatusEffectsChangedEvent;
import com.wynntils.models.statuseffects.type.StatusEffect;
import com.wynntils.models.worlds.event.WorldStateEvent;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.bus.api.SubscribeEvent;

public final class ShamanMaskModel
extends Model {
    private static final Pattern AWAKENED_PATTERN = Pattern.compile("^\u00a7[0-9a-f]\u00a7lAwakened$");
    private static final Pattern MASK_PATTERN = Pattern.compile("\u00a7(?:b|6|c)Mask of the (Heretic|Lunatic|Fanatic)");
    private static final StyledText AWAKENED_STATUS_EFFECT = StyledText.fromString("\u00a77Awakened");
    private ShamanMaskType currentMaskType = ShamanMaskType.NONE;
    private ShamanMaskType previousMaskType = ShamanMaskType.NONE;

    public ShamanMaskModel() {
        super(List.of());
    }

    @SubscribeEvent
    public void onTitle(TitleSetTextEvent event) {
        if (this.currentMaskType == ShamanMaskType.AWAKENED) {
            return;
        }
        StyledText title = StyledText.fromComponent(event.getComponent());
        if (title.matches(AWAKENED_PATTERN)) {
            this.previousMaskType = this.currentMaskType;
            this.currentMaskType = ShamanMaskType.AWAKENED;
            ShamanMaskTitlePacketEvent maskEvent = new ShamanMaskTitlePacketEvent();
            WynntilsMod.postEvent(maskEvent);
            if (maskEvent.isCanceled()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onSubtitle(SubtitleSetTextEvent event) {
        StyledText title = StyledText.fromComponent(event.getComponent());
        if (title.contains("Mask of the ") || title.contains("\u27a4")) {
            this.parseMask(title);
            if (this.currentMaskType == null) {
                return;
            }
            ShamanMaskTitlePacketEvent maskEvent = new ShamanMaskTitlePacketEvent();
            WynntilsMod.postEvent(maskEvent);
            if (maskEvent.isCanceled()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onStatusChange(StatusEffectsChangedEvent event) {
        if (this.currentMaskType != ShamanMaskType.AWAKENED) {
            return;
        }
        Optional<StatusEffect> awakenedEffects = Models.StatusEffect.getStatusEffects().stream().filter(statusEffect -> AWAKENED_STATUS_EFFECT.equals(statusEffect.getName())).findFirst();
        if (awakenedEffects.isEmpty()) {
            this.currentMaskType = this.previousMaskType;
        }
    }

    @SubscribeEvent
    public void onCharacterDeath(CharacterDeathEvent event) {
        this.resetMask();
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        this.resetMask();
    }

    private void resetMask() {
        this.currentMaskType = ShamanMaskType.NONE;
    }

    private void parseMask(StyledText title) {
        Matcher matcher = title.getMatcher(MASK_PATTERN);
        ShamanMaskType parsedMask = ShamanMaskType.NONE;
        if (matcher.matches()) {
            parsedMask = ShamanMaskType.find(matcher.group(1));
        } else {
            for (ShamanMaskType type : ShamanMaskType.values()) {
                if (type.getParseString() == null || !title.contains(type.getParseString())) continue;
                parsedMask = type;
                break;
            }
        }
        this.currentMaskType = parsedMask;
    }

    public ShamanMaskType getCurrentMaskType() {
        return this.currentMaskType;
    }
}

