/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilities.bossbars;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.bossbar.TrackedBar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BloodPoolBar
extends TrackedBar {
    private static final Pattern BLOOD_POOL_PATTERN = Pattern.compile("\u00a7cBlood Pool \u00a74\\[\u00a7c(\\d+)%\u00a74\\]");
    private int current;

    public BloodPoolBar() {
        super(BLOOD_POOL_PATTERN);
    }

    @Override
    public void onUpdateName(Matcher match) {
        try {
            this.current = Integer.parseInt(match.group(1));
        }
        catch (NumberFormatException e) {
            WynntilsMod.error(String.format("Failed to parse current for blood pool bar (%s)", match.group(1)));
        }
    }

    @Override
    public void onUpdateProgress(float progress) {
        if (progress != 0.0f) {
            int unroundedMax = (int)((float)this.current / progress);
            int remainder = unroundedMax % 10;
            int max = unroundedMax - remainder;
            if (remainder > 5) {
                max += 10;
            }
            this.updateValue(this.current, max);
        }
    }
}

