/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.container.ContainerQueryException;
import com.wynntils.handlers.container.scriptedquery.QueryStep;
import com.wynntils.handlers.container.scriptedquery.ScriptedContainerQuery;
import com.wynntils.handlers.container.type.ContainerContent;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;

public class DialogueHistoryQueries {
    private static final int DIALOGUE_HISTORY_SLOT = 58;
    private static final Pattern DIALOGUE_HISTORY_PAGE_PATTERN = Pattern.compile("\u00a78Page (\\d+) of (\\d+)");
    private static final StyledText DIALOGUE_HISTORY = StyledText.fromString("Dialogue History");
    private List<List<StyledText>> newDialogueHistory;

    protected void scanDialogueHistory() {
        if (this.newDialogueHistory != null) {
            return;
        }
        this.newDialogueHistory = new ArrayList<List<StyledText>>();
        ScriptedContainerQuery query = ScriptedContainerQuery.builder("Dialogue History Query").onError(msg -> {
            WynntilsMod.warn("Problem getting dialogue history: " + msg);
            McUtils.sendErrorToClient("Dumping Dialogue History failed");
            this.newDialogueHistory = null;
        }).then(QueryStep.useItemInHotbar(8).expectContainerTitle("\udaff\udfee\ue004")).repeat(this::checkDialoguePage, QueryStep.clickOnSlot(58)).execute(() -> {
            Models.Activity.setDialogueHistory(this.newDialogueHistory);
            this.newDialogueHistory = null;
        }).build();
        query.executeQuery();
    }

    private boolean checkDialoguePage(ContainerContent c) throws ContainerQueryException {
        class_1799 dialogueHistoryItem = c.items().get(58);
        if (!StyledText.fromComponent(dialogueHistoryItem.method_7964()).equals(DIALOGUE_HISTORY)) {
            throw new ContainerQueryException("Could not find dialogue history item");
        }
        ArrayList<StyledText> dialogue = new ArrayList<StyledText>();
        for (StyledText line : LoreUtils.getLore(dialogueHistoryItem)) {
            Matcher matcher = line.getMatcher(DIALOGUE_HISTORY_PAGE_PATTERN);
            if (matcher.matches()) {
                int currentPage = Integer.parseInt(matcher.group(1));
                int maxPage = Integer.parseInt(matcher.group(2));
                this.newDialogueHistory.add(dialogue);
                return currentPage != maxPage;
            }
            if (line.isBlank()) continue;
            dialogue.add(line);
        }
        throw new ContainerQueryException("Could not find page line");
    }
}

